% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncaa_game_logs.R
\name{ncaa_game_logs}
\alias{ncaa_game_logs}
\title{\strong{Get NCAA Baseball Game Logs}}
\usage{
ncaa_game_logs(player_id, year, type = "batting", span = "game")
}
\arguments{
\item{player_id}{A player's unique id. Can be found using the
get_ncaa_baseball_roster function.}

\item{year}{The year of interest.}

\item{type}{The kind of statistics you want to return. Current options
are 'batting' or 'pitching'.}

\item{span}{The span of time; can either be 'game' for game logs in a season, or 'career' which
returns seasonal stats for a player's career.}
}
\value{
A data frame containing player and school information
as well as game by game statistics\tabular{ll}{
   col_name \tab types \cr
   player_id \tab numeric \cr
   player_name \tab character \cr
   Date \tab character \cr
   Opponent \tab character \cr
   Result \tab character \cr
   App \tab numeric \cr
   G \tab numeric \cr
   GS \tab numeric \cr
   IP \tab numeric \cr
   CG \tab numeric \cr
   H \tab numeric \cr
   R \tab numeric \cr
   ER \tab numeric \cr
   BB \tab numeric \cr
   SO \tab numeric \cr
   SHO \tab numeric \cr
   BF \tab numeric \cr
   P-OAB \tab numeric \cr
   2B-A \tab numeric \cr
   3B-A \tab numeric \cr
   Bk \tab numeric \cr
   HR-A \tab numeric \cr
   WP \tab numeric \cr
   HB \tab numeric \cr
   IBB \tab numeric \cr
   Inh Run \tab numeric \cr
   Inh Run Score \tab numeric \cr
   SHA \tab numeric \cr
   SFA \tab numeric \cr
   Pitches \tab numeric \cr
   GO \tab numeric \cr
   FO \tab numeric \cr
   W \tab numeric \cr
   L \tab numeric \cr
   SV \tab numeric \cr
   OrdAppeared \tab numeric \cr
   KL \tab numeric \cr
   pickoffs \tab character \cr
}
}
\description{
\strong{Get NCAA Baseball Game Logs}
}
\examples{
\donttest{
  try(ncaa_game_logs(player_id = 2113782, year = 2021, type = "pitching", span = "game"))
  try(ncaa_game_logs(player_id = 1879650, year = 2019, type = "batting", span = "career"))
}
}
