% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncaa_baseball_pbp.R
\name{ncaa_baseball_pbp}
\alias{ncaa_baseball_pbp}
\title{\strong{Get Play-By-Play Data for NCAA Baseball Games}}
\usage{
ncaa_baseball_pbp(game_info_url)
}
\arguments{
\item{game_info_url}{The url for the game's play-by-play data. This can be
found using the get_ncaa_schedule_info function.}
}
\value{
A data frame with play-by-play data for an individual game.\tabular{ll}{
   col_name \tab types \cr
   date \tab character \cr
   location \tab character \cr
   attendance \tab logical \cr
   inning \tab character \cr
   inning_top_bot \tab character \cr
   score \tab character \cr
   batting \tab character \cr
   fielding \tab character \cr
   description \tab character \cr
}
}
\description{
\strong{Get Play-By-Play Data for NCAA Baseball Games}
}
\examples{
\donttest{
  x <- ncaa_schedule_info(736, 2021)$game_info_url[2]
  try(ncaa_baseball_pbp(game_info_url = x))
}
}
