% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fit_mult_impute_observed_outcome.R
\name{fit_mult_impute_obs_outcome}
\alias{fit_mult_impute_obs_outcome}
\title{Fit a model on multiply imputed data using only observatoin with non-missing
outcome(s)}
\usage{
fit_mult_impute_obs_outcome(mids, formula, fitter, ...)
}
\arguments{
\item{mids}{a mids object, i.e. the imputed dataset.}

\item{formula}{a formula that describes the model to be fit. The outcome (y
variable) in the formula will be used to remove missing cases.}

\item{fitter}{a modeling function (not in quotes) that is compatible with
\code{Hmisc::fit.mult.impute()}.}

\item{...}{additional arguments to \code{Hmisc::fit.mult.impute()}.}
}
\value{
mod a fit.mult.impute object.
}
\description{
This function fits a regression model using \code{Hmisc::fit.mult.impute()} on a
multiply imputed dataset generated with \code{mice::mice()}. Cases with a
missing outcome in the original dataset are removed from the mids object
before model fitting.
}
\examples{
# create an imputed dataset
imputed_data <- mice::mice(airquality)

fit_mult_impute_obs_outcome(mids = imputed_data, formula = Ozone ~ Solar.R + Wind, fitter = glm)

}
\author{
Till D. Best
}
