% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{gg_raster}
\title{Plot raster objects using \code{ggplot}}
\usage{
gg_raster(r, r_type = "RGB", gglayer = F, ...)
}
\arguments{
\item{r}{raster of class \code{SpatRaster}, \code{RasterLayer}, \code{RasterBrick} or \code{RasterStack}.}

\item{r_type}{character, either \code{"gradient"} or \code{"discrete"}.}

\item{gglayer}{logical, if \code{FALSE} (default), a \code{ggplot2} plot is returned, if \code{TRUE}, a \code{ggplot2} layer is returned.}

\item{...}{additional arguments, including
\itemize{
   \item \code{maxpixels}, numeric, maximum number of pixels to be plotted (default: 500000)
   \item \code{alpha}, numeric between 0 and 1, alpha value of the plotted data (transparency).
   \item \code{maxColorValue}, numeric, the value  to use as colour maximum.
   \item \code{interpolate}, logical, whether to smooth the plot (default is \code{TRUE}).
}}
}
\value{
A \code{ggplot2} object
}
\description{
This function plots objects of class \code{SpatRaster}, \code{RasterLayer}, \code{RasterBrick} or \code{RasterStack} as \code{ggplot2}. It is used internally by \code{basemap*} functions that return \code{ggplot} plots.
}
\examples{
library(basemaps)

# example extent
data(ext)

\dontrun{
# raster object: Brick
map <- basemap_raster(ext)

# plotting RasterBrick
gg_raster(map, r_type = "RGB")
}

}
