% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickTable.R
\name{qhtbl}
\alias{qhtbl}
\title{Quickly render a basic table in HTML.}
\usage{
qhtbl(
  dataFrameOrMatrix,
  columnNamesAsColumnHeaders = TRUE,
  explicitColumnHeaders = NULL,
  rowNamesAsRowHeaders = FALSE,
  firstColumnAsRowHeaders = FALSE,
  explicitRowHeaders = NULL,
  numberOfColumnsAsRowHeaders = 0,
  columnFormats = NULL,
  columnCellTypes = NULL,
  theme = NULL,
  replaceExistingStyles = FALSE,
  tableStyle = NULL,
  headingStyle = NULL,
  cellStyle = NULL,
  totalStyle = NULL,
  ...
)
}
\arguments{
\item{dataFrameOrMatrix}{The data frame or matrix containing the data to be
displayed in the table.}

\item{columnNamesAsColumnHeaders}{TRUE to use the data frame column names
as the column headers in the table.}

\item{explicitColumnHeaders}{A character vector of column headers.}

\item{rowNamesAsRowHeaders}{TRUE to use the data frame row names as the
row headers in the table.}

\item{firstColumnAsRowHeaders}{TRUE to use the first column in the data
frame as row headings.}

\item{explicitRowHeaders}{A character vector of row headers.}

\item{numberOfColumnsAsRowHeaders}{The number of columns to be set as row
headers.}

\item{columnFormats}{A list containing format specifiers, each of which is
either an sprintf() character value, a list of format() arguments or an
R function that provides custom formatting logic.}

\item{columnCellTypes}{A vector that is the same length as the
number of columns in the data frame, where each element is one of
the following values that specifies the type of cell: root, rowHeader,
columnHeader, cell, total.  The cellType controls the default styling
that is applied to the cell.  Typically only rowHeader, cell or total
would be used.}

\item{theme}{Either the name of a built-in theme (default, largeplain,
compact or blank/none) or a list which specifies the default formatting for
the table.}

\item{replaceExistingStyles}{TRUE to completely replace the default styling
with the specified tableStyle, headingStyle, cellStyle and/or totalStyle}

\item{tableStyle}{A list of CSS style declarations that apply to the table.}

\item{headingStyle}{A list of CSS style declarations that apply to the
heading cells in the table.}

\item{cellStyle}{A list of CSS style declarations that apply to the normal
cells in the table.}

\item{totalStyle}{A list of CSS style declarations that apply to the total
cells in the table.}

\item{...}{Additional arguments, currently compatibility, argumentCheckMode
and/or styleNamePrefix.}
}
\value{
A basic table.
}
\description{
The \code{qhpvt} function renders a basic table as a HTML widget with
one line of R.
}
\examples{
qhtbl(bhmsummary[1:5, c("GbttWeekDate", "Origin", "Destination", "TrainCount",
  "OnTimeArrivals")])
qhtbl(bhmsummary[1:5, c("GbttWeekDate", "Origin", "Destination", "TrainCount",
  "OnTimeArrivals")], columnNamesAsColumnHeaders=FALSE,
  explicitColumnHeaders=c("Week", "From", "To", "Trains", "On-Time"))

}
