% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mem-mcmc.r
\name{mem_mcmc}
\alias{mem_mcmc}
\title{Fit the MEM Model using MCMC}
\usage{
mem_mcmc(
  responses,
  size,
  name,
  p0 = 0.15,
  shape1 = 0.5,
  shape2 = 0.5,
  prior = diag(length(responses))/2 + matrix(0.5, nrow = length(responses), ncol =
    length(responses)),
  hpd_alpha = 0.05,
  alternative = "greater",
  mcmc_iter = 2e+05,
  mcmc_burnin = 50000,
  initial_mem = round(prior - 0.001),
  seed = 1000,
  cluster_analysis = FALSE,
  call = NULL,
  cluster_function = cluster_membership
)
}
\arguments{
\item{responses}{the number of responses in each basket.}

\item{size}{the size of each basket.}

\item{name}{the name of each basket.}

\item{p0}{the null response rate for the poster probability calculation
(default 0.15).}

\item{shape1}{the first shape parameter(s) for the prior of each basket
(default 0.5).}

\item{shape2}{the second shape parameter(s) for the prior of each basket
(default 0.5).}

\item{prior}{the matrix giving the prior inclusion probability
for each pair of baskets. The default is on on the main diagonal and 0.5
elsewhere.}

\item{hpd_alpha}{the highest posterior density trial significance.}

\item{alternative}{the alternative case definition (default greater)}

\item{mcmc_iter}{the number of MCMC iterations.}

\item{mcmc_burnin}{the number of MCMC Burn_in iterations.}

\item{initial_mem}{the initial MEM matrix.}

\item{seed}{the random number seed.}

\item{cluster_analysis}{if the cluster analysis is conducted.}

\item{call}{the call of the function.}

\item{cluster_function}{a function to cluster baskets}
}
\description{
Fit the MEM model using Bayesian Metropolis-Hasting MCMC
inference.
}
\examples{
\donttest{
# 3 baskets, each with enrollement size 5
trial_sizes <- rep(5, 3)

# The response rates for the baskets.
resp_rate <- 0.15

# The trials: a column of the number of responses and a column of the
# the size of each trial.
trials <- data.frame(
  responses = rbinom(trial_sizes, trial_sizes, resp_rate),
  size = trial_sizes,
  name = letters[1:3]
)
res <- mem_mcmc(trials$responses, trials$size)
}
}
