% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{batch_config}
\alias{batch_config}
\title{Configure Batch Processing}
\usage{
batch_config(fun, path, regexp = ".*", recurse = FALSE, ...)
}
\arguments{
\item{fun}{A function to process each of the files.
\code{fun}'s first argument should be a string of the path to a single file.
If processing is unsuccessful \code{fun} should return FALSE
or throw an error (error messages are caught and automatically logged).
If fun deletes or modifies the file then it is no longer considered
for processing.}

\item{path}{A string of the path to the directory with the files for processing.}

\item{regexp}{A string of a regular expression. Only non-hidden file names
which match the regular expression will be batch processed.}

\item{recurse}{A flag specifying whether to recurse into path's subdirectories.}

\item{...}{Additional arguments passed to \code{fun}.}
}
\value{
An invisible character vector of the paths to the files to
that will be processed when \code{\link[=batch_run]{batch_run()}} is called.
}
\description{
Configures a directory for batch file processing by \code{\link[=batch_run]{batch_run()}}.
}
\details{
\code{batch_config()} creates a hidden configuration file in path
named '.batchr.rds'.

The contents of the file can be read using
\code{\link[=batch_config_read]{batch_config_read()}}
or updated using \code{\link[=batch_reconfig_fun]{batch_reconfig_fun()}}.

Configuration is only possible if the directory does not already contain
a configuration file.
If \code{recurse = TRUE} then the subdirectories
must also not contain configuration files.

The regexp must match at least one non-hidden file in the directory
or if \code{recurse = TRUE} in the directory or subdirectories.
Hidden files are excluded to prevent accidental modification of system files.
}
\examples{
path <- tempdir()
write.csv(mtcars, file.path(path, "file1.csv"))
batch_config(function(x) TRUE, path, regexp = "[.]csv$")
batch_run(path, ask = FALSE)
batch_cleanup(path)
unlink(file.path(path, "file1.csv"))
}
\seealso{
\code{\link[=batch_process]{batch_process()}} and \code{\link[=batch_run]{batch_run()}}
}
