% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_reaction_time.R
\name{b_reaction_time}
\alias{b_reaction_time}
\title{b_reaction_time}
\usage{
b_reaction_time(t, s, priors = NULL, warmup = 1000, iter = 2000,
  chains = 4, seed = NULL, refresh = NULL, control = NULL,
  suppress_warnings = TRUE)
}
\arguments{
\item{t}{a vector containing reaction times for each measurement.}

\item{s}{a vector containing subject indexes. Starting index should be 1 and the largest subject index should equal the number of subjects.}

\item{priors}{List of parameters and their priors - b_prior objects. You can put a prior on the mu_m (mean), sigma_m (variance of mu_m), mu_s (variance), sigma_s (variance of mu_s), mu_l (mean of the exponent factor) and sigma_l (variance of mu_l) parameters (default = NULL).}

\item{warmup}{Integer specifying the number of warmup iterations per chain (default = 1000).}

\item{iter}{Integer specifying the number of iterations (including warmup, default = 2000).}

\item{chains}{Integer specifying the number of parallel chains (default = 4).}

\item{seed}{Random number generator seed (default = NULL).}

\item{refresh}{Frequency of output (default = NULL).}

\item{control}{A named list of parameters to control the sampler's behavior (default = NULL).}

\item{suppress_warnings}{Suppress warnings returned by Stan (default = TRUE).}
}
\value{
An object of class `reaction_time_class`
}
\description{
Bayesian model for comparing reaction times.
}
\examples{
\donttest{
# priors
mu_prior <- b_prior(family="normal", pars=c(0, 100))
sigma_prior <- b_prior(family="uniform", pars=c(0, 500))
lambda_prior <- b_prior(family="uniform", pars=c(0.05, 5))

# attach priors to relevant parameters
priors <- list(c("mu_m", mu_prior),
              c("sigma_m", sigma_prior),
              c("mu_s", sigma_prior),
              c("sigma_s", sigma_prior),
              c("mu_l", lambda_prior),
              c("sigma_l", sigma_prior))

# generate data
s <- rep(1:5, 20)
rt <- emg::remg(100, mu=10, sigma=1, lambda=0.4)

# fit
fit <- b_reaction_time(t=rt, s=s, priors=priors, chains=1)
}

}
