% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{survival_outcome}
\alias{survival_outcome}
\title{Piecewise constant hazard rates and the cutpoint for control and treatment group}
\usage{
survival_outcome(
  hazard_treatment = NULL,
  cutpoint = NULL,
  hazard_control = NULL,
  .data = NULL
)
}
\arguments{
\item{hazard_treatment}{vector. Constant hazard rates under the treatment arm.}

\item{cutpoint}{vector. The change-point vector indicating time when the hazard rates change.}

\item{hazard_control}{vector. Constant hazard rates under the control arm.}

\item{.data}{NULL. stores the hazard rates and cutpoint, please do not fill it in.}
}
\value{
a list with hazard rates and cutpoint for control and treatment group.
}
\description{
Wrapper function for the piecewise constant hazard rates and the cutpoint
for control and treatment group.
}
\examples{
survival_outcome(hazard_treatment = 0.06,
                           hazard_control   = 0.08,
                           cutpoint         = NULL )
}
