% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdpbinomial.R
\name{bdpbinomial}
\alias{bdpbinomial}
\alias{bdpbinomial,ANY-method}
\title{Bayesian Discount Prior: Binomial counts}
\usage{
bdpbinomial(y_t = NULL, N_t = NULL, y0_t = NULL, N0_t = NULL,
  y_c = NULL, N_c = NULL, y0_c = NULL, N0_c = NULL, alpha_max = 1,
  a0 = 1, b0 = 1, number_mcmc = 10000, weibull_scale = 0.135,
  weibull_shape = 3, two_side = 1)
}
\arguments{
\item{y_t}{scalar. Number of events for the current treatment group.}

\item{N_t}{scalar. Sample size of the current treatment group.}

\item{y0_t}{scalar. Number of events for the historical treatment group.}

\item{N0_t}{scalar. Sample size of the historical treatment group.}

\item{y_c}{scalar. Number of events for the current control group.}

\item{N_c}{scalar. Sample size of the current control group.}

\item{y0_c}{scalar. Number of events for the historical control group.}

\item{N0_c}{scalar. Sample size of the historical control group.}

\item{alpha_max}{scalar. Maximum weight the discount function can apply.
Default is 1. For a two-arm trial, users may specify a vector of two values
where the first value is used to weight the historical treatment group and
the second value is used to weight the historical control group.}

\item{a0}{scalar. Prior value for the beta rate. Default is 1.}

\item{b0}{scalar. Prior value for the beta rate. Default is 1.}

\item{number_mcmc}{scalar. Number of Markov Chain Monte Carlo (MCMC)
simulations. Default is 10000.}

\item{weibull_scale}{scalar. Scale parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 0.135. Two values have special treatment: 0 and Inf. For
weibull_scale = 0, alpha is set to 0, i.e., no weight. For
weibull_scale = Inf, alpha is set to 1, i.e., full weight. For a two-arm
trial, users may specify a vector of two values where the first value is
used to estimate the weight of the historical treatment group and the
second value is used to estimate the weight of the historical control
group.}

\item{weibull_shape}{scalar. Shape parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 3. For a two-arm trial, users may specify a vector of two values
where the first value is used to estimate the weight of the historical
treatment group and the second value is used to estimate the weight of the
historical control group.}

\item{two_side}{scalar. Indicator of two-sided test for the discount
function. Default value is 1.}
}
\value{
\code{bdpbinomial} returns an object of class "bdpbinomial".
The functions \code{summary} and \code{print} are used to obtain and
print a summary of the results, including user inputs. The \code{plot}
function displays visual outputs as well.

An object of class \code{bdpbinomial} is a list containing at least
the following components:

\describe{
 \item{\code{posterior_treatment}}{
   list. Entries contain values related to the treatment group:}
   \itemize{
     \item{\code{alpha_discount}}{
       numeric. Alpha value, the weighting parameter of the historical data.}
     \item{\code{pvalue}}{
       numeric. The posterior probability of the stochastic comparison
       between the current and historical data.}
     \item{\code{posterior}}{
       vector. The posterior of the treatment group, incorporating the
       weighted historical data.}
     \item{\code{posterior_flat}}{
       vector. The distribution of the current treatment group, i.e., no
       incorporation of the historical data.}
     \item{\code{prior}}{
       vector. The distribution of the historical treatment group.}
  }
 \item{\code{posterior_control}}{
   list. Similar entries as \code{posterior_treament}. Only present if
   control group is specified.}
 \item{\code{f1}}{
   list. Entries contain values related to the posterior effect:}
   \itemize{
     \item{\code{density_post_treatment}}{
       object of class \code{density}. Used internally to plot the density of
       the treatment group posterior.}
     \item{\code{density_flat_treatment}}{
       object of class \code{density}. Used internally to plot the density of
       the treatment group "flat" distribution.}
     \item{\code{density_prior_treatment}}{
       object of class \code{density}. Used internally to plot the density of
       the treatment group prior.}
     \item{\code{density_post_control}}{
       object of class \code{density}. Used internally to plot the density of
       the control group (if present) posterior.}
     \item{\code{density_flat_control}}{
       object of class \code{density}. Used internally to plot the density of
       the control group (if present) "flat" distribution.}
     \item{\code{density_prior_control}}{
       object of class \code{density}. Used internally to plot the density of
       the control group (if present) prior.}
     \item{\code{TestMinusControl_post}}{
       vector. If control group is present, vector contains posterior
       distribution of the effect estimate of treatment vs. control.
       control groups.}
  }
 \item{\code{args1}}{
   list. Entries contain user inputs. In addition, the following elements
   are ouput:}
   \itemize{
     \item{\code{arm2}}{
       binary indicator. Used internally to indicate one-arm or two-arm
       analysis.}
     \item{\code{intent}}{
       character. Denotes current/historical status of treatment and
       control groups.}
  }
}
}
\description{
\code{bdpbinomial} is used for estimating posterior samples from a
  Binomial outcome where an informative prior is used. The prior weight
  is determined using a discount function. This code is modeled after
  the methodologies developed in Haddad et al. (2017).
}
\details{
\code{bdpbinomial} uses a two-stage approach for determining the
  strength of historical data in estimation of a binomial count mean outcome.
  In the first stage, a Weibull distribution function is used as a
  \emph{discount function} that defines the maximum strength of the
  historical data (via \code{weibull_shape}, \code{weibull_scale}, and
  \code{alpha_max}) and discounts based on disagreement with the current data.
  Disagreement between current and historical data is determined by stochastically
  comparing the respective posterior distributions under noninformative priors.
  With binomial data, the comparison is the proability (\code{p}) that the current
  count is less than the historical count. The comparison metric \code{p} is then
  input into the Weibull discount function and the final strength of the
  historical data is returned (alpha).

 In the second stage, posterior estimation is performed where the discount
 function parameter, \code{alpha}, is used as a fixed value for all posterior
 estimation procedures.

 To carry out a single arm (OPC) analysis, data for the current treatment
 (\code{y_t} and \code{N_t}) and historical treatment (\code{y0_t} and
 \code{N0_t}) must be input. The results are then based on the posterior
 distribution of the current data augmented by the historical data.

 To carry our a two-arm (RCT) analysis, data for the current treatment and
 current control (\code{y_c} and \code{N_c}) must be input,
 as well as at least one of the historical treatment and historical control
 (\code{y0_c} and \code{N0_c}). The results
 are then based on the posterior distribution of the difference between
 current treatment and control, augmented by available historical data.
}
\examples{
# One-arm trial (OPC) example
fit <- bdpbinomial(y_t           = 10,
                   N_t           = 500,
                   y0_t          = 25,
                   N0_t          = 250)
summary(fit)
print(fit)
#plot(fit)

# Two-arm (RCT) example
fit2 <- bdpbinomial(y_t = 10,
                    N_t = 500,
                    y0_t = 25,
                    N0_t = 250,
                    y_c = 8,
                    N_c = 500,
                    y0_c = 20,
                    N0_c = 250)
summary(fit2)
print(fit2)
#plot(fit2)

}
