% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convdiag_bmrm.R
\name{convdiag_bmrm}
\alias{convdiag_bmrm}
\title{Convergence Diagnostics on MCMC samples in \code{bmrm}}
\usage{
convdiag_bmrm(x , var="P", convdiag="geweke",print=TRUE,...)
}
\arguments{
\item{x}{an object of class \code{bmrm}, the output of the \code{bmrm} function}

\item{var}{name of a variable to which convergence disagnostics apply. It should be one of "A" (source contribution matrix),
"P" (source composition or profile matrix), "Sigma" (error variance).}

\item{convdiag}{vector of convergence diagnostic methods. It should be any subvector
of ("geweke", "heidel","raftery" ) (default="geweke").}

\item{print}{TRUE/FALSE, print convergence diagnostics results (default=TRUE)}

\item{...}{arguments to be passed to methods}
}
\value{
A list of  convergence diagnostics results
\describe{
  \item{convdiag}{selected convergence diagnostic methods}
  \item{geweke}{Geweke's z-scores and p-values if \code{convdiag}
 includes "geweke", NULL if \code{convdiag} does not include "geweke"}
  \item{heidel}{Heidelberger and Welch's stationary test results
and p-values if \code{convdiag} includes "heidel"; NULL if
\code{convdiag} does not include "heidel"}
\item{raftery}{Raftery and Lewis's estimates of burn-in, minimum number of iterations,
and thinning if \code{convdiag} includes "raftery"; NULL if
\code{convdiag} does not include "raftery"}
}
}
\description{
Compute convergence diagnostics of
 Geweke (1992), Heidelberger and Welch (1983), Raftery and Lewis(1992).
}
\details{
Geweke's convergence diagnostic for Markov chains is based on
 a test for equality of the means of the first and last part of a Markov chain
 (by default the first 10\% and the last 50\%).
 If the samples are drawn from the stationary distribution of the chain,
 the two means should be equal and Geweke's statistic has an asymptotically
 standard normal distribution. We use the function \code{geweke.diag} in \bold{coda}
  package (with default option) which provides the test statistics
  (standard Z-scores) and the upper bound of
  and p-values.

 Heidelberger and Welch's  convergence diagnostic tests the
 null hypothesis that the sampled values come from a stationary distribution.
  The test is successively applied, firstly to the whole chain, then after
   discarding the first 10\%, 20\%, ... of the chain until either
   the null hypothesis is accepted, or 50\% of the chain has been discarded.
   We use the function  \code{heidel.diag} (with default option)
   which provides the staionary test results and p-values.

Raftery and Lewis's diagnostic estimates the minimum number of iterations, burn-in,
thinning interval for zero autocorrelation, satisfying specified conditions
regarding quantile \eqn{q} of parameters of interest. The conditions are
specified by a posterior quantile \eqn{q} of parameters, an acceptable
tolerance (accuracy) \eqn{r} for \eqn{q}, a probability \eqn{s} of being
within the interval \eqn{q-r, q+r}.
We use the function  \code{raftery.diag} (with default option).
}
\examples{
\donttest{
data(Elpaso)
Y=Elpaso$Y ; muP=Elpaso$muP
q=nrow(muP)
out.Elpaso <- bmrm(Y,q,muP, nAdapt=1000,nBurnIn=5000,nIter=5000,nThin=1)
conv1<-convdiag_bmrm(out.Elpaso,var="P",convdiag="raftery" )
conv2<-convdiag_bmrm(out.Elpaso,var="A", convdiag="geweke")
conv3<-convdiag_bmrm(out.Elpaso,var="Sigma", convdiag=c("geweke","heidel"))
conv4<-convdiag_bmrm(out.Elpaso,var="Sigma", convdiag=c("geweke","heidel", "raftery"))
}
}
\references{
Geweke, J.(1992) Evaluating the accuracy of sampling-based
approaches to calculating posterior moments. In Bayesian Statistics 4
(ed JM Bernado, JO Berger, AP Dawid and AFM Smith). Clarendon Press.

Heidelberger P, and Welch PD. (1981) A spectral method for
confidence interval generation and run length control in simulations.
Comm. ACM. 24, 233-245.

Heidelberger P. and Welch PD.(1983) Simulation run length
control in the presence of an initial transient.
Opns Res., 31, 1109-44,Oxford, UK.

Plummer, M., Best, N., Cowles, K. and Vines K. (2006) CODA:
Convergence Diagnosis and Output Analysis for MCMC, R News, Vol 6, pp. 7-11.

Raftery, A.E. and Lewis, S.M. (1992). One long run with diagnostics:
Implementation strategies for Markov chain Monte Carlo. Statistical Science, 7, 493-497.

Raftery, A.E. and Lewis, S.M. (1995). The number of iterations,
 convergence diagnostics and generic Metropolis algorithms. In Practical Markov Chain Monte
 Carlo (W.R. Gilks, D.J. Spiegelhalter and S. Richardson, eds.). London, U.K.: Chapman and Hall.
}
