% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchy.R
\name{get_reconc_matrices}
\alias{get_reconc_matrices}
\title{Build hierarchy matrices}
\usage{
get_reconc_matrices(agg_levels, h)
}
\arguments{
\item{agg_levels}{user-selected list of aggregation levels.}

\item{h}{number of steps ahead for the bottom level forecasts.}
}
\value{
A list containing the named elements:
\itemize{
\item \code{A} the aggregation matrix;
\item \code{S} the summing matrix.
}
}
\description{
Creates the aggregation and summing matrices for a temporal hierarchy of time series
from a user-selected list of aggregation levels.
}
\examples{

library(bayesRecon)

#Create monthly hierarchy
agg_levels <- c(1,2,3,4,6,12)
h <- 12
rec_mat <- get_reconc_matrices(agg_levels, h)
S <- rec_mat$S
A <- rec_mat$A

}
\seealso{
\code{\link[=temporal_aggregation]{temporal_aggregation()}}
}
