\name{vecr2matr}
\alias{vecr2matr}
\title{
  Transform single component indeces to double component indeces
}
\description{
  Components of a bivariate G-spline can be indexed in several
  ways. Suppose that the knots in the first dimension are
  \eqn{\mu_{1,-K_1},\dots,\mu_{1,K_1}}{mu[1,-K1],...,mu[1,K1]}
  and the knots in the second dimension
  \eqn{\mu_{2,-K_2},\dots,\mu_{2,K_2}.}{mu[2,-K2],...,mu[2,K2].}
  I.e. we have \eqn{2K_1+1}{2*K[1]+1} knots in the first dimension and
  \eqn{2K_2+1}{2*K[2]+1} knots in the second dimension. Each G-spline
  component can have a double index \eqn{(k_1,k_2)}{(k[1],k[2])}
  assigned which means that it corresponds to the knot
  \eqn{(\mu_{1,k_1},\mu_{2,k_2})}{(mu[1,k1], mu[2,k2])}
  or alternatively the same G-spline component can have a~single index
  \deqn{r=(k_2 + K_2)\times(2K_1+1) + k_1 + K_1 + 1}{%
    r=(k[2]+K[2])*(2*K[1]+1) + k[1] + K[1] + 1}
  assigned where \eqn{r}{r} takes values from
  \eqn{1,\dots,K_1\times K_2}{1,...,K[1]*K[2]}. Single indexing is used
  for example by files \code{r.sim} and \code{r_2.sim} generated by
  functions \code{\link{bayesHistogram}}, \code{\link{bayesBisurvreg}},
  \code{\link{bayessurvreg2}} to save some space.

  This function serves to translate single indeces to double indeces
  using the relationship
  \deqn{k_1 = (r - 1) \mbox{ mod } (2K_1+1) - K_1}{%
    k[1] = (r-1) \%\% (2*K[1]+1) - K[1]}
  \deqn{k_2 = (r - 1) \mbox{ div } (2K_1+1) - K_2}{%
    k[2] = (r-1) \%\ \% (2*K[1]+1) - K[2]}

  The function can be used also in one dimensional case when a~simple
  relationship holds
  \deqn{r = k + K + 1}{r = k + K + 1}  
  \deqn{k = r - 1 - K}{k = r - 1 - K}
}
\usage{
vecr2matr(vec.r, KK)
}
\arguments{
  \item{vec.r}{a~vector of single indeces}
  \item{KK}{a~vector with numbers of knots on each side of the central
    knot for each dimension of the G-spline. The length of \code{KK}
    determines dimension of the G-spline}
}
\value{
  In bivariate case: a~matrix with two columns and as many rows as the
  length of \code{vec.r}.

  In univariate case: a~vector with as ,amy components as the length of \code{vec.r}.
}  
\examples{
### Bivariate G-spline
### with 31 knots in each dimension
KK <- c(15, 15)

### First observation in component (-15, -15),
### second observation in component (15, 15),
### third observation in component (0, 0)
vec.r <- c(1, 961, 481)
vecr2matr(vec.r, KK)
}
\author{
  Arnošt Komárek \email{arnost.komarek@mff.cuni.cz}
}
\keyword{connection}

