% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.matrix.bayesbr.R
\name{model_frame}
\alias{model_frame}
\title{Model Matrix/Frame with All Variables for \code{bayesbr} Objects}
\usage{
model_frame(object,...)
}
\arguments{
\item{object}{an object of the class \emph{bayesbr}, containing the list returned from the \code{\link{bayesbr}} function.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A matrix or Frame containing all variables in the model and their names used as column names.
}
\description{
The function receives all variables and their respective names, and concatenates them in a matrix.
}
\examples{
data("bodyfat",package="bayesbr")
\dontshow{
lines = sample(1:251,50)
bodyfat = bodyfat[lines,]
}
bbr = bayesbr(siri ~ wrist +I(age/100)|chest, data = bodyfat,
             iter = 100)
model_matrix(bbr)

model_frame(bbr)
}
\seealso{
\code{\link{values}},\code{\link{bayesbr}}
}
