% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.bayesbr.R
\name{summary.bayesbr}
\alias{summary.bayesbr}
\title{Summary for \code{bayesbr} Objects}
\usage{
\method{summary}{bayesbr}(object,type = c("","quantile","sweighted",
"pearson","ordinary"), prob = 0.95,...)
}
\arguments{
\item{object}{an object of the class \emph{bayesbr}, containing the list returned from the \code{\link{bayesbr}} function.}

\item{type}{A character containing the residual type returned by the model among the possibilities. The type of residue can be \emph{quantile}, \emph{sweighted}, \emph{pearson} or \emph{ordinary}. The default is \emph{quantile}.}

\item{prob}{a probability containing the credibility index for the HPD interval for the coefficients of the covariates.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
A method that receives a list of the bayesbr type and its items and displays the main information of the model, such as the residuals, a table containing statistics on the estimated coefficients and information to evaluate the quality of the model.
}
\examples{
data("bodyfat",package="bayesbr")
\dontshow{
lines = sample(1:251,15)
bodyfat = bodyfat[lines,]
}
bbr = bayesbr(siri ~ age + weight +
              wrist | biceps + forearm,
              data = bodyfat, iter = 100)

summary(bbr)
summary(bbr, type="pearson")
summary(bbr, prob = 0.9)
summary(bbr, prob = 0.99, resid.type="sweighted")
\donttest{
bbr2 = bayesbr(siri ~ age + weight + height +
           wrist | biceps + forearm, data = bodyfat,
           iter = 100,mean_betas = 3,
           variance_betas = 10)

summary(bbr2)
summary(bbr2, type="sweighted")
summary(bbr2, prob = 0.96)
summary(bbr2, prob = 0.95, resid.type="quantile")
}
}
\seealso{
\code{\link{bayesbr}},\code{\link{residuals.bayesbr}},\code{\link{print.bayesbr}},\code{\link{predict.bayesbr}}
}
