% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_regime_model.R
\name{plot_regime_model}
\alias{plot_regime_model}
\title{Plot the state probabilities from \code{\link[=find_regimes]{find_regimes()}}}
\usage{
plot_regime_model(model, probs = c(0.05, 0.95), type = c("probability",
  "means"), regime_prob_threshold = 0.9, plot_prob_indices = NULL,
  flip_regimes = FALSE)
}
\arguments{
\item{model}{A model returned by \code{\link[=find_regimes]{find_regimes()}}.}

\item{probs}{A numeric vector of quantiles to plot the credible intervals at.
Defaults to \code{c(0.05, 0.95)}.}

\item{type}{Whether to plot the probabilities (default) or means.}

\item{regime_prob_threshold}{The probability density that must be above 0.5.
Defaults to 0.9 before we classify a regime (only affects \code{"means"} plot).}

\item{plot_prob_indices}{Optional indices of probability plots to plot.
Defaults to showing all.}

\item{flip_regimes}{Optional whether to flip regimes in plots, defaults to FALSE}
}
\description{
Plot the state probabilities from \code{\link[=find_regimes]{find_regimes()}}
}
\details{
Note that the original timeseries data (dots) are shown scaled
between 0 and 1.
}
\examples{
data(Nile)
m <- fit_regimes(log(Nile), n_regimes = 2, chains = 1, iter = 800)
plot_regime_model(m)
plot_regime_model(m, plot_prob_indices=c(2))
plot_regime_model(m, type = "means")
}
