% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian.R
\name{bayesian}
\alias{bayesian}
\alias{update.bayesian}
\alias{bayesian_fit}
\alias{bayesian_formula}
\alias{bayesian_terms}
\alias{bayesian_family}
\alias{bayesian_predict}
\alias{bayesian_write}
\alias{bayesian_read}
\title{General Interface for Bayesian TidyModels}
\usage{
bayesian(
  mode = "regression",
  prior = NULL,
  inits = NULL,
  chains = NULL,
  iter = NULL,
  warmup = NULL,
  thin = NULL,
  cores = NULL,
  algorithm = NULL,
  backend = NULL,
  control = NULL,
  future = NULL,
  seed = NULL,
  refresh = NULL,
  silent = NULL
)

\method{update}{bayesian}(
  object,
  parameters = NULL,
  prior = NULL,
  inits = NULL,
  chains = NULL,
  iter = NULL,
  warmup = NULL,
  thin = NULL,
  cores = NULL,
  algorithm = NULL,
  backend = NULL,
  control = NULL,
  future = NULL,
  seed = NULL,
  refresh = NULL,
  silent = NULL,
  fresh = FALSE,
  ...
)

bayesian_fit(formula, data, ...)

bayesian_formula(formula, ...)

bayesian_terms(formula, ...)

bayesian_family(family, ...)

bayesian_predict(object, ...)

bayesian_write(object, file)

bayesian_read(file)
}
\arguments{
\item{mode}{A single character string for the type of model.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{prior}{One or more \code{brmsprior} objects created by
\code{\link[brms]{set_prior}} or related functions and combined using the
\code{c} method or the \code{+} operator.
See also \code{\link[brms]{get_prior}} for more help.}

\item{inits}{Either \code{"random"} or \code{"0"}. If inits is
\code{"random"} (the default), \pkg{Stan} will randomly generate initial
values for parameters. If it is \code{"0"}, all parameters are initialized
to zero. This option is sometimes useful for certain families, as it happens
that default (\code{"random"}) inits cause samples to be essentially
constant. Generally, setting \code{inits = "0"} is worth a try, if chains
do not behave well. Alternatively, \code{inits} can be a list of lists
containing the initial values, or a function (or function name) generating
initial values. The latter options are mainly implemented for internal
testing but are available to users if necessary. If specifying initial
values using a list or a function then currently the parameter names must
correspond to the names used in the generated \pkg{Stan} code (not the names
used in \R). For more details on specifying initial values you can consult
the documentation of the selected \code{backend}.}

\item{chains}{Number of Markov chains (defaults to 4).}

\item{iter}{Number of total iterations per chain (including warmup; defaults
to 2000).}

\item{warmup}{A positive integer specifying number of warmup (aka burnin)
iterations. This also specifies the number of iterations used for stepsize
adaptation, so warmup samples should not be used for inference. The number
of warmup should not be larger than \code{iter} and the default is
\code{iter/2}.}

\item{thin}{Thinning rate. Must be a positive integer. Set \code{thin > 1} to
save memory and computation time if \code{iter} is large.}

\item{cores}{Number of cores to use when executing the chains in parallel,
which defaults to 1 but we recommend setting the \code{mc.cores} option to
be as many processors as the hardware and RAM allow (up to the number of
chains). For non-Windows OS in non-interactive \R sessions, forking is used
instead of PSOCK clusters.}

\item{algorithm}{Character string naming the estimation approach to use.
Options are \code{"sampling"} for MCMC (the default), \code{"meanfield"}
for variational inference with independent normal distributions,
\code{"fullrank"} for variational inference with a multivariate normal
distribution, or \code{"fixed_param"} for sampling from fixed parameter
values. Can be set globally for the current \R session via the
\code{"brms.algorithm"} option (see \code{\link{options}}).}

\item{backend}{Character string naming the package to use as the backend for
fitting the \pkg{Stan} model. Options are \code{"rstan"} (the default) or
\code{"cmdstanr"}. Can be set globally for the current \R session via the
\code{"brms.backend"} option (see \code{\link{options}}). Details on the
\pkg{rstan} and \pkg{cmdstanr} packages are available at
\url{https://mc-stan.org/rstan/} and \url{https://mc-stan.org/cmdstanr/},
respectively.}

\item{control}{A named \code{list} of parameters to control the sampler's
behavior. It defaults to \code{NULL} so all the default values are used.
The most important control parameters are discussed in the 'Details'
section below. For a comprehensive overview see
\code{\link[rstan]{stan}}.}

\item{future}{Logical; If \code{TRUE}, the \pkg{\link[future]{future}}
package is used for parallel execution of the chains and argument
\code{cores} will be ignored. Can be set globally for the current \R
session via the \code{future} option. The execution type is controlled via
\code{\link[future]{plan}} (see the examples section below).}

\item{seed}{The seed for random number generation to make results
reproducible. If \code{NA} (the default), \pkg{Stan} will set the seed
randomly.}

\item{refresh}{(non-negative integer) The number of iterations between
printed screen updates. If \code{refresh = 0}, only error messages will be
printed.}

\item{silent}{Logical; If \code{TRUE} (the default), most of the
informational messages of compiler and sampler are suppressed. The actual
sampling progress is still printed. Set \code{refresh = 0} to turn this off
as well. If using \code{backend = "rstan"} you can also set
\code{open_progress = FALSE} to prevent opening additional progress bars.}

\item{object}{A Bayesian model specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main}
parameters to update. If the individual arguments are used,
these will supersede the values in \code{parameters}. Also, using
engine arguments in this object will result in an error.}

\item{fresh}{A logical for whether the arguments should be
modified in-place of or replaced wholesale.}

\item{...}{Other arguments passed to internal functions.}

\item{formula}{An object of class \code{\link[stats:formula]{formula}},
\code{\link[brms]{brmsformula}}, or \code{\link[brms]{mvbrmsformula}} (or one that can
be coerced to that classes): A symbolic description of the model to be
fitted. The details of model specification are explained in
\code{\link[brms]{brmsformula}}.}

\item{data}{An object of class \code{data.frame} (or one that can be coerced
to that class) containing data of all variables used in the model.}

\item{family}{A description of the response distribution and link function to
be used in the model. This can be a family function, a call to a family
function or a character string naming the family. Every family function has
a \code{link} argument allowing to specify the link function to be applied
on the response variable. If not specified, default links are used. For
details of supported families see \code{\link[brms]{brmsfamily}}. By default, a
linear \code{gaussian} model is applied. In multivariate models,
\code{family} might also be a list of families.}

\item{file}{A character string of the file path to \code{brmsfit} object
saved via \code{\link{saveRDS}}.}
}
\value{
An updated model specification.
}
\description{
\code{bayesian()} is a way to generate a \emph{specification} of a model
before fitting and allows the model to be created using
\pkg{Stan} via \pkg{brms} package in R. The main
arguments for the model are:
\itemize{
\item \code{prior} One or more \code{brmsprior} objects created by
\code{\link[brms]{set_prior}} or related functions and combined using
the \code{c} method or the \code{+} operator. See also
\code{\link[brms]{get_prior}} for more help.
\item \code{inits} Either \code{"random"} or \code{"0"}. If inits is
\code{"random"} (the default), \pkg{Stan} will randomly generate initial
values for parameters. If it is \code{"0"}, all parameters are initialized
to zero. This option is sometimes useful for certain families, as it happens
that default (\code{"random"}) inits cause samples to be essentially
constant. Generally, setting \code{inits = "0"} is worth a try, if chains
do not behave well. Alternatively, \code{inits} can be a list of lists
containing the initial values, or a function (or function name) generating
initial values. The latter options are mainly implemented for internal
testing but are available to users if necessary. If specifying initial
values using a list or a function then currently the parameter names must
correspond to the names used in the generated \pkg{Stan} code (not the names
used in \R). For more details on specifying initial values you can consult
the documentation of the selected \code{backend}.
\item \code{chains} Number of Markov chains (defaults to 4).
\item \code{iter} Number of total iterations per chain (including warmup;
defaults to 2000).
\item \code{warmup} A positive integer specifying number of warmup
(aka burnin) iterations. This also specifies the number of iterations
used for stepsize adaptation, so warmup samples should not be used for
inference. The number of warmup should not be larger than \code{iter}
and the default is \code{iter/2}.
\item \code{thin} Thinning rate. Must be a positive integer. Set
\code{thin > 1} to save memory and computation time if \code{iter} is
large.
\item \code{cores} Number of cores to use when executing the chains in
parallel, which defaults to 1 but we recommend setting the \code{mc.cores}
option to be as many processors as the hardware and RAM allow (up to the
number of chains). For non-Windows OS in non-interactive \R sessions,
forking is used instead of PSOCK clusters.
\item \code{algorithm} Character string naming the estimation approach
to use. Options are \code{"sampling"} for MCMC (the default),
\code{"meanfield"} for variational inference with independent normal
distributions, \code{"fullrank"} for variational inference with
a multivariate normal distribution, or \code{"fixed_param"} for sampling
from fixed parameter values. Can be set globally for the current \R session
via the \code{"brms.algorithm"} option (see \code{\link{options}}).
\item \code{backend} Character string naming the package to use as the
backend for fitting the \pkg{Stan} model. Options are \code{"rstan"} (the
default) or \code{"cmdstanr"}. Can be set globally for the current \R
session via the \code{"brms.backend"} option (see \code{\link{options}}).
Details on the \pkg{rstan} and \pkg{cmdstanr} packages are available at
\url{https://mc-stan.org/rstan/} and \url{https://mc-stan.org/cmdstanr/},
respectively.
\item \code{control} A named \code{list} of parameters to control the
sampler's behavior. It defaults to \code{NULL} so all the default values
are used.
The most important control parameters are discussed in the 'Details'
section below. For a comprehensive overview see
\code{\link[rstan]{stan}}.
\item \code{future} Logical; If \code{TRUE}, the
\pkg{\link[future]{future}} package is used for parallel execution of
the chains and argument \code{cores} will be ignored. Can be set
globally for the current \R session via the \code{future} option.
The execution type is controlled via \code{\link[future]{plan}}
(see the examples section below).
\item \code{seed} The seed for random number generation to make results
reproducible. If \code{NA} (the default), \pkg{Stan} will set the seed
randomly.
\item \code{refresh} (non-negative integer) The number of iterations
between printed screen updates. If \code{refresh = 0}, only error messages
will be printed.
\item \code{silent} Logical; If \code{TRUE} (the default), most of the
informational messages of compiler and sampler are suppressed. The actual
sampling progress is still printed. Set \code{refresh = 0} to turn this off
as well. If using \code{backend = "rstan"} you can also set
\code{open_progress = FALSE} to prevent opening additional progress bars.
}
These arguments are converted to their specific names at the
time that the model is fit. Other options and argument can be
set using \code{set_engine()}. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
The data given to the function are not saved and are only used
to determine the \emph{mode} of the model. For \code{bayesian()}, the
possible modes are "regression" and "classification".

The model can be created by the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{brms}:  \code{"brms"}
}
}
\section{Engine Details}{
Engines may have pre-set default arguments when executing the model fit
call. For this type of model, the template of the fit calls are:\if{html}{\out{<div class="r">}}\preformatted{bayesian() \%>\%
  set_engine("brms") \%>\%
  translate()
}\if{html}{\out{</div>}}\preformatted{## Bayesian Model Specification (regression)
## 
## Computational engine: brms 
## 
## Model fit template:
## bayesian::bayesian_fit(formula = missing_arg(), data = missing_arg(), 
##     family = brms::brmsfamily("gaussian"))
}
}

\examples{

bayesian()

show_model_info("bayesian")

bayesian(mode = "classification")
bayesian(mode = "regression")
\dontrun{
bayesian_mod <-
  bayesian() \%>\%
  set_engine("brms") \%>\%
  fit(
    rating ~ treat + period + carry + (1 | subject),
    data = inhaler
  )

summary(bayesian_mod$fit)
}

# -------------------------------------------------------------------------
model <- bayesian(inits = "random")
model
update(model, inits = "0")
update(model, inits = "0", fresh = TRUE)
}
\seealso{
\code{\link[brms]{brm}},
\code{\link[brms]{brmsfit}},
\code{\link[brms]{update.brmsfit}},
\code{\link[brms]{predict.brmsfit}},
\code{\link[brms]{posterior_epred.brmsfit}},
\code{\link[brms]{posterior_predict.brmsfit}},
\code{\link[brms]{brmsformula}},
\code{\link[brms]{brmsformula-helpers}},
\code{\link[brms]{brmsterms}},
\code{\link[brms]{brmsfamily}},
\code{\link[brms]{customfamily}},
\code{\link[stats]{family}},
\code{\link[stats]{formula}},
\code{\link[stats]{update.formula}}.
}
