% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_helper_functions.R
\name{get_behav_hist}
\alias{get_behav_hist}
\title{Extract bin estimates from Latent Dirichlet Allocation or mixture model}
\usage{
get_behav_hist(dat, nburn, ngibbs, nmaxclust, var.names)
}
\arguments{
\item{dat}{The list object returned by the LDA model
(\code{\link{cluster_segments}}) or mixture model
(\code{\link{cluster_obs}}). Used for extracting the element \emph{phi}.}

\item{nburn}{numeric. The length of the burn-in phase.}

\item{ngibbs}{numeric. The total number of iterations of the MCMC chain.}

\item{nmaxclust}{numeric. The maximum number of clusters on which to
attribute behaviors.}

\item{var.names}{character. A vector of names used for each of the movement
variables. Must be in the same order as were listed within the data frame
returned by \code{\link{summarize_tsegs}} (if running LDA model).}
}
\value{
A data frame that contains columns for bin number, behavioral state,
  proportion represented by a given bin, and movement variable name. This is
  displayed in a long format, which is easier to visualize using
  \code{ggplot2}.
}
\description{
Pulls model results for the estimates of bin proportions per movement
variable from the posterior distribution. This can be used for visualization
of movement variable distribution for each behavior estimated.
}
\examples{

\donttest{
#load data
data(tracks.seg)

#select only id, tseg, SL, and TA columns
tracks.seg2<- tracks.seg[,c("id","tseg","SL","TA")]

#summarize data by track segment
obs<- summarize_tsegs(dat = tracks.seg2, nbins = c(5,8))

#cluster data with LDA
res<- cluster_segments(dat = obs, gamma1 = 0.1, alpha = 0.1, ngibbs = 1000,
                       nburn = 500, nmaxclust = 7, ndata.types = 2)

#Extract proportions of behaviors per track segment
theta.estim<- extract_prop(res = res, ngibbs = 1000, nburn = 500, nmaxclust = 7)

#run function for clustered segments
behav.res<- get_behav_hist(dat = res, nburn = 500, ngibbs = 1000, nmaxclust = 7,
                           var.names = c("Step Length","Turning Angle"))
}

}
