## ----message=FALSE, warning=FALSE, include=FALSE-------------------------
library(knitr)
options(knitr.kable.NA = '')
knitr::opts_chunk$set(comment=">")
options(digits=2)

set.seed(333)

## ----message=FALSE, warning=FALSE, eval=FALSE----------------------------
#  library(rstanarm)
#  library(bayestestR)
#  library(see)
#  
#  data <- iris  # Use the iris data
#  model <- stan_glm(Sepal.Length ~ Sepal.Width, data=data)  # Fit model

## ----echo=FALSE, message=FALSE, warning=FALSE, comment=">"---------------
library(rstanarm)
library(bayestestR)
library(see)
set.seed(333)

data <- iris  # Use the iris data
junk <- capture.output(model <- stan_glm(Sepal.Length ~ Sepal.Width, data=data))

## ----echo=TRUE, message=FALSE, warning=FALSE, comment=">"----------------
# Compute indices
pd <- p_direction(model)
percentage_in_rope <- rope(model, ci=1)

# Visualise the pd
plot(pd)
pd

# Visualise the percentage in ROPE
plot(percentage_in_rope)
percentage_in_rope

## ----message=FALSE, warning=FALSE, eval=FALSE----------------------------
#  data$Sepal.Width_scaled <- data$Sepal.Width / 100  # Divide predictor by 100
#  model <- stan_glm(Sepal.Length ~ Sepal.Width_scaled, data=data)  # Fit model

## ----echo=FALSE, message=FALSE, warning=FALSE, comment=">"---------------
set.seed(333)
data$Sepal.Width_scaled <- data$Sepal.Width / 100
junk <- capture.output(model <- stan_glm(Sepal.Length ~ Sepal.Width_scaled, data=data))

## ----echo=TRUE, message=FALSE, warning=FALSE, comment=">"----------------
# Compute indices
pd <- p_direction(model)
percentage_in_rope <- rope(model, ci=1)

# Visualise the pd
plot(pd)
pd

# Visualise the percentage in ROPE
plot(percentage_in_rope)
percentage_in_rope

