% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_censpp.R
\name{censpp}
\alias{censpp}
\alias{censpp.default}
\alias{censpp.lcens}
\alias{censpp.mcens}
\alias{censpp.default}
\alias{censpp.lcens}
\alias{censpp.mcens}
\title{Probability Plotting Positions}
\usage{
censpp(x, a = 0.44)

\method{censpp}{default}(x, a = 0.44)

\method{censpp}{lcens}(x, a = 0.44)

\method{censpp}{mcens}(x, a = 0.44)
}
\arguments{
\item{x}{a vector of observations}

\item{a}{the offset fraction to be used; typically in [0, 0.5].}
}
\value{
A list with these components:

Note that \code{xrcn} and \code{pprcn} are provided only if there are
right-censored values.
\item{x}{ sorted uncensored observations.}
\item{pp}{ corresponding plotting positions for uncensored observations.}
\item{xcen}{ sorted left-censored observations.}
\item{ppcen}{ corresponding plotting positions for left-censored
observations.}
\item{xrcn}{ sorted right-censored observations.}
\item{pprcn}{ corresponding plotting positions for right-censored
observations.}
}
\description{
Generates the sequence of probability points for uncensored and censored
values
}
\note{
The left-censored plotting positions are adjusted by the method of
Helsel and Cohn (1988), which produces a mean of 0.5 for all data.
}
\examples{
# This example demonstrates the probability adjustments made for censoring
# The raw, uncensored data:
ppoints(7, .44)
# censor ar 0.5 (the lowest 3 values)
censpp(as.lcens(ppoints(7, .44), 0.5))

}
\references{
Helsel, D.R. and Cohn, T.A., 1988, Estimation of descriptive
statistics for multiply censored water quality data: Water Resources
Research v. 24, n. 12, pp.1997-2004
}
\seealso{
\code{\link{ppoints}}
}
\keyword{internal}
\keyword{manip}
