% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_subset.R
\name{[.lcens}
\alias{[.lcens}
\alias{[.mcens}
\alias{[.qw}
\alias{subset.qw}
\title{Subset an Object}
\usage{
\method{[}{lcens}(x, i, ...)

\method{[}{mcens}(x, i, ...)

\method{[}{qw}(x, i, ...)

\method{subset}{qw}(x, subset, ...)
}
\arguments{
\item{x}{any R object to subset.}

\item{i}{index specifying elements to extract.}

\item{\dots}{not used, required for other methods.}

\item{subset}{an logical expression involving a slot name of the qw object.}
}
\value{
A subset of the object \code{x}.
}
\description{
Extracts or subsets a vector: methods for "lcens," "mcens," and "qw" data.
}
\details{
The values for \code{i} can be either numeric indexes or logical.\cr
Valid slot names are "remark.codes," "reporting.level," "reporting.method,"
"reporting.units," "analyte.method," "analyte.name," and "unique.code."
}
\note{
In general, assignment of specific values should not be done using the
"[" extraction operator because it does not modify the meta data assiciated
with a value. But any value can be set to \code{NA} by treating the value as
a matrix and setting the equivalent of the row to \code{NA}. See the example below.
}
\examples{
Xcens <- as.lcens(c(1, 2, 3, 4), 2)
# Extract the 3rd value
Xcens[3]
# Change the 3rd value to NA and print the data
Xcens[3,] <- NA
Xcens
}
\seealso{
\code{\link{[.qw}}
}
\keyword{internal}
\keyword{manip}
