% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbn.predict.R
\name{bbn.predict}
\alias{bbn.predict}
\title{Bayesian Belief Network Prediction}
\usage{
bbn.predict(
  bbn.model,
  ...,
  boot_max = 1,
  values = 1,
  figure = 1,
  font.size = 5
)
}
\arguments{
\item{bbn.model}{A matrix or dataframe of interactions between different model \code{nodes}.}

\item{...}{An X by 2 array of initial changes to the system under investigation.
It requires at least 1 prior scenario (up to 12 priors).
The first column should be a -4 to 4 (including 0) integer value for each \code{node} in the network with negative values
indicating a decrease and positive values representing an increase. 0 represents no change.
Note, names included here are included as outputs in tables and figures.
Shortening these names can provide better figures.}

\item{boot_max}{The number of bootstraps to perform. Suggested range for exploratory analysis 1-1000.
For final analysis recommended size = 1000 - 10000 - note, this can take a long time to run.
Default value is 1, running with no \code{bootstrapping} - suitable for exploration of data and error checking.}

\item{values}{This provides a numeric output of \code{posterior} values and any \code{confidence intervals}.
Default value 1. Set to 0 to hide this output.}

\item{figure}{Sets the figure options. Default value 1. 0 = no figures produced.
1 = figure is saved in working directory as a PDF file (note, this is overwritten if the name is not changed, and no figure is produced if the existing PDF is open when the new one is generated).
2 = figure is produced in a graphics window.
All figures are combined on a single plot where scenario 2 is below scenario 1 (i.e. scenarios work in columns then rows)}

\item{font.size}{Font size for the plot labels. Defaults to 5.}
}
\value{
Plots of the \code{(BBN)} predictions and optionally prints the predicted values.
}
\description{
\code{bbn.predict} performs predictions using a Bayesian Belief Network \code{(BBN)} model,
accommodating multiple \code{priors} scenarios and allowing for \code{bootstrapping} to assess variability.
}
\details{
\itemize{
  \item Supports input of multiple \code{priors} through \code{ellipsis()}.
  \item Allows \code{bootstrapping} with a specified number of maximum iterations to assess prediction variability.
  \item Generates \code{plots} for visual representation of the predictions.
}
}
\examples{
data(my_BBN, combined)
bbn.predict(bbn.model = my_BBN, priors1 = combined, boot_max=100, values=1, figure=1, font.size=5)

}
