% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{oi_async}
\alias{oi_async}
\title{Syntactic Sugar for Asynchronous Optimization Instance Construction}
\usage{
oi_async(
  objective,
  search_space = NULL,
  terminator,
  check_values = FALSE,
  callbacks = NULL,
  rush = NULL
)
}
\arguments{
\item{objective}{(\link{Objective})\cr
Objective function.}

\item{search_space}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies the search space for the \link{Optimizer}. The \link[paradox:ParamSet]{paradox::ParamSet}
describes either a subset of the \code{domain} of the \link{Objective} or it describes
a set of parameters together with a \code{trafo} function that transforms values
from the search space to values of the domain. Depending on the context, this
value defaults to the domain of the objective.}

\item{terminator}{\link{Terminator}\cr
Termination criterion.}

\item{check_values}{(\code{logical(1)})\cr
Should points before the evaluation and the results be checked for validity?}

\item{callbacks}{(list of \link[mlr3misc:Callback]{mlr3misc::Callback})\cr
List of callbacks.}

\item{rush}{(\code{Rush})\cr
If a rush instance is supplied, the tuning runs without batches.}
}
\description{
Function to construct an \link{OptimInstanceAsyncSingleCrit} and \link{OptimInstanceAsyncMultiCrit}.
}
