% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{oi}
\alias{oi}
\title{Syntactic Sugar for Optimization Instance Construction}
\usage{
oi(
  objective,
  search_space = NULL,
  terminator,
  callbacks = NULL,
  check_values = TRUE,
  keep_evals = "all"
)
}
\arguments{
\item{objective}{(\link{Objective})\cr
Objective function.}

\item{search_space}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies the search space for the \link{Optimizer}. The \link[paradox:ParamSet]{paradox::ParamSet}
describes either a subset of the \code{domain} of the \link{Objective} or it describes
a set of parameters together with a \code{trafo} function that transforms values
from the search space to values of the domain. Depending on the context, this
value defaults to the domain of the objective.}

\item{terminator}{\link{Terminator}\cr
Termination criterion.}

\item{callbacks}{(list of \link[mlr3misc:Callback]{mlr3misc::Callback})\cr
List of callbacks.}

\item{check_values}{(\code{logical(1)})\cr
Should points before the evaluation and the results be checked for validity?}

\item{keep_evals}{(\code{character(1)})\cr
Keep \code{all} or only \code{best} evaluations in archive?}
}
\description{
Function to construct a \link{OptimInstanceBatchSingleCrit} and \link{OptimInstanceBatchMultiCrit}.
}
