% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{MAP}
\alias{MAP}
\title{Get the Maximum A Posteriori(MAP) estimate of a "BayesianBrick" object}
\usage{
MAP(obj, ...)
}
\arguments{
\item{obj}{A "BayesianBrick" object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list of the MAP estimates
}
\description{
This is a generic function that will generate the MAP estimate of a given "BayesianBrick" object. For the model structure:  \cr
     theta|gamma ~ H(gamma) \cr
     X|theta ~ F(theta) \cr
MAP esitmate of theta is theta_MAP = argmax_theta p(theta|gamma,x).
}
\seealso{
\code{\link{MAP.GaussianNIW}} for Gaussian-NIW conjugate structure, \code{\link{MAP.GaussianNIG}} for Gaussian-NIG conjugate structure, \code{\link{MAP.CatDirichlet}} for Categorical-Dirichlet conjugate structure, \code{\link{MAP.CatDP}} for Categorical-DP conjugate structure ...
}
