% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross-validation-KNN.R
\name{CVknn}
\alias{CVknn}
\title{Cross-validation for K nearest-neighbor regression}
\usage{
CVknn(X, Dvec, V, K.list = NULL, type = "eucli", plot = FALSE)
}
\arguments{
\item{X}{a numeric design matrix, which used in \code{\link{rhoKNN}} to estimate probabilities of the disease status.}

\item{Dvec}{a n * 3  binary matrix with three columns, corresponding to the three classes of the disease status. In row i, 1 in column j indicates that the i-th subject belongs to class j, with j = 1, 2, 3. A row of \code{NA} values indicates a non-verified subject.}

\item{V}{a binary vector containing the verification status (1 verified, 0 not verified).}

\item{K.list}{a list of candidate values for K. If \code{NULL}(the default), the set \eqn{\{1, 2, ..., n.ver\}}{{1, 2, ..., n.ver}} is employed, where, \eqn{n.ver} is the number of verified subjects.}

\item{type}{a type of distance, see \code{\link{rhoKNN}} for more details. Default \code{"eucli"}.}

\item{plot}{if \code{TRUE}, a plot of cross-validation prediction error is produced.}
}
\value{
A suitable choice for K is returned.
}
\description{
This function calculates the estimated cross-validation prediction error for K nearest-neighbor regression and returns a suitable choice for K.
}
\details{
Data are divided into two groups, the first contains the data corresponding to V = 1, whereas the second contains the data corresponding to V = 0. In the first group, the discrepancy between the true disease status and the KNN estimates of the probabilities of the disease status is computed by varying \code{K} from 1 to the number of verification subjects, see To Duc et al. (2016). The optimal value of \code{K} is the value that corresponds to the smallest value of the discrepancy.
}
\examples{
data(EOC)
XX <- cbind(EOC$CA125, EOC$CA153, EOC$Age)
Dna <- preDATA(EOC$D, EOC$CA125)
Dvec.na <- Dna$Dvec
CVknn(XX, Dvec.na, EOC$V, type = "mahala", plot = TRUE)

}
\references{
To Duc, K., Chiogna, M., Adimari, G. (2016): Nonparametric Estimation of ROC Surfaces Under Verification Bias. \url{https://arxiv.org/abs/1604.04656v1}. Submitted.
}
