% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_subjects.R
\name{get_subjects}
\alias{get_subjects}
\title{Get subject id codes.}
\usage{
get_subjects(
  parentId = "",
  sort = c("id", "-id", "name", "-name"),
  lang = c("pl", "en"),
  ...
)
}
\arguments{
\item{parentId}{A parent subject id code. If not specified returns all top level subjects.
Use \code{\link{search_subjects}} to find subject codes.}

\item{sort}{A type of sorting, "id" (default), "-id", "name", "-name"}

\item{lang}{A language of returned data, "pl" (default), "en"}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A dataset as a tibble.
}
\description{
Retrieve all subjects id's or sub-subjects.
}
\details{
To get all top level subjects skip the \code{parentId} parameter or list
  sub-subjects for given parent subject.


  To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
 \donttest{
   get_subjects()
   get_subjects("K3")
   get_subjects("G7")
}
}
\keyword{search}
\keyword{subjects}
\keyword{utilities}
