% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{coefWriteout}
\alias{coefWriteout}
\title{Create \code{data.table} with \code{bdotsObj} parameters}
\usage{
coefWriteout(bdObj)
}
\arguments{
\item{bdObj}{An object returned from \code{bdotsFit} or \code{bdotsRefit}}
}
\value{
A \code{data.table} matching parameter values to observations
}
\description{
Creates an object of class \code{data.table} that matches
parameter values for each observation. This can then be
passed to the \code{bdotsRefit} function
}
\examples{
\dontrun{
fit <- bdotsFit(data = cohort_unrelated,
                subject = "Subject",
                time = "Time",
                y = "Fixations",
                group = c("Group", "LookType"),
                curveType = doubleGauss(concave = TRUE),
                cor = TRUE,
                numRefits = 2,
                cores = 0,
                verbose = FALSE)
parDT <- coefWriteout(fit)
}
}
