% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_execute.R
\docType{methods}
\name{pipeline_execute}
\alias{pipeline_execute}
\title{Initiates the pipelining process.}
\usage{
pipeline_execute(configurationFilePath = NULL, editConfigurationFile = FALSE, filesPath,
pipe = SerialPipe$new(), instanceFactory = InstanceFactory$new())
}
\arguments{
\item{configurationFilePath}{(\emph{character}) path where the configuration
file is located. The file must have the .ini extension. In the case that the
argument is null, the default configuration file (configurationsTemplate.ini)
will be used.}

\item{editConfigurationFile}{(\emph{boolean}) indicates whether a file is
opened to modify the configuration file or not.}

\item{filesPath}{(\emph{character}) path where the files to be preprocessed
are located.}

\item{pipe}{(\emph{TypePipe}) subclass of \code{\link{TypePipe}}, which
implements the whole pipeling process.}

\item{instanceFactory}{(\emph{InstanceFactory}) object implementing
the method \code{createInstance} to choose which type of \code{\link{Instance}}
is created.}
}
\value{
List of \code{\link{Instance}} that have been preprocessed.
}
\description{
\strong{pipeline_execute} is responsible for easily initialize
the pipelining preprocessing proccess.
}
\section{Details}{

The configuration file can be indicated by the user or use the default
configuration file (configurationsTemplate.ini). In addition, once we call
the function, it will be possible to choose if the user
wants to edit the file of indicated configurations or not.

The \emph{configurationFilePath} file should have the following structure
(Depends on the Pipes used). Also the configurationsTemplate.ini has this
structure:

\strong{[twitter]}

ConsumerKey = \emph{<<consumer_key>>}

ConsumerSecret = \emph{<<consumer_secret>>}

AccessToken = \emph{<<access_token>>}

AccessTokenSecret = \emph{<<access_token_secret>>}

\strong{[youtube]}

app_id = \emph{<<app_id>>}

app_password = \emph{<<app_password>>}

\strong{[eml]}

PartSelectedOnMPAlternative = \emph{<<part_selected>>} (text/html or text/plain)

\strong{[resourcesPath]}

resourcesAbbreviationsPath = \emph{<<resources_abbreviations_path>>}

resourcesContractionsPath = \emph{<<resources_contractions_path>>}

resourcesInterjectionsPath = \emph{<<resources_interjections_path>>}

resourcesSlangsPath = \emph{<<resources_slangs_path>>}

resourcesStopWordsPath = \emph{<<resources_stopWords_path>>}

\strong{[CSVPath]}

outPutTeeCSVPipePath = \emph{<<out_put_teeCSVPipe_path>>}

\strong{[cache]}

cachePathTwtid = \emph{<<cache_path_twtid>>}

cachePathYtbid = \emph{<<cache_path_ytbid>>}
}

\section{Notes}{

In the case of choosing to edit the configuration file, the default editor
will be opened.
}

\examples{
\dontrun{
#Path where the configuration file are located
configurationFilePath <- system.file("configurations",
                                     "configurationsExample.ini",
                                     package ="bdpar")

#Folder with the files to preprocess
filesPath <- system.file("testFiles",
                          package = "bdpar")

#Object which indicates the pipes' flow
pipe <- SerialPipe$new()

#Object which decides how creates the instances
instanceFactory <- InstanceFactory$new()

#Starting file preprocessing...
pipeline_execute(configurationFilePath = configurationFilePath,
                 filesPath = filesPath,
                 pipe = pipe,
                 instanceFactory = instanceFactory)
}
}
