% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlangPipe.R
\docType{class}
\name{SlangPipe}
\alias{SlangPipe}
\title{Class to find and/or replace the slangs on the data field of an Instance}
\usage{
SlangPipe
}
\description{
\code{\link{SlangPipe}} class is responsible for detecting
the existing slangs in the \strong{data} field of each \code{\link{Instance}}.
Identified slangs are stored inside the \strong{slang} field of
\code{\link{Instance}} class. Moreover if needed, is able to perform inline
slangs replacement.
}
\section{Constructor}{

\preformatted{
SlangPipe$new(propertyName = "langpropname",
              propertyLanguageName = "language",
              alwaysBeforeDeps = list("GuessLanguagePipe"),
              notAfterDeps = list(),
              replaceSlangs = TRUE)
}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{propertyLanguageName:}}{
(\emph{character}) name of the language property.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
\item{\strong{replaceSlangs:}}{
(\emph{logical}) indicates if the slangs are replace or not.
}
}
}
}
}

\section{Details}{

\code{\link{SlangPipe}} class requires the resource files (in json format)
containing the correspondence between slangs and meaning. To this end,
the language of the text indicated in the \emph{propertyLanguageName} should
be contained in the resource file name (ie. slang.xxx.json where xxx is the
value defined in the \emph{propertyLanguageName} ). The location of the
resources should be defined in the \strong{"resources.slangs.path"} field of
\emph{\link{bdpar.Options}} variable.
}

\section{Note}{

\code{\link{SlangPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
preprocesses the \code{\link{Instance}} to obtain/replace the slangs.
The slangs found in the Pipe are added to the list of properties of the
\code{\link{Instance}}.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
}
}
}
}

\item{\bold{findSlang:}}{
checks if the slang is in the data.
\itemize{
\item{\emph{Usage:}}{
\code{findSlang(data, slang)}
}
\item{\emph{Value:}}{
boolean, depending on whether the slang is on the data.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text where slang will be searched.
\item{\strong{slang:}}{
(\emph{character}) indicates the slang to find.
}
}
}
}
}
}

\item{\bold{replaceSlang:}}{
replaces the slang in the data for the extendedSlang.
\itemize{
\item{\emph{Usage:}}{

\code{replaceSlang(slang, extendedSlang, data)}
}
\item{\emph{Value:}}{
the data with slangs replaced.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{slang:}}{
(\emph{character}) indicates the slang to replace.
}
\item{\strong{extendedSlang:}}{
(\emph{character}) indicates the string to replace for the slangs found.
}
\item{\strong{data:}}{
(\emph{character}) text where slang will be replaced.
}
}
}
}
}

\item{\bold{getPropertyLanguageName:}}{
gets of name of property language.
\itemize{
\item{\emph{Usage:}}{

\code{getPropertyLanguageName()}
}
\item{\emph{Value:}}{
value of name of property language.
}
}
}

\item{\bold{getResourcesSlangsPath:}}{
gets of path of slangs resources.
\itemize{
\item{\emph{Usage:}}{

\code{getResourcesSlangsPath()}
}
\item{\emph{Value:}}{

value of path of slangs resources.
}
}
}

\item{\bold{setResourcesSlangsPath:}}{
sets the path of slangs resources.
\itemize{
\item{\emph{Usage:}}{
\code{setResourcesSlangsPath(path)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{path:}}{
(\emph{character}) the new value of the path of slangs resources.
}
}
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{propertyLanguageName:}}{
 (\emph{character}) the name of property about language.
}
\item{\bold{resourcesSlangsPath:}}{
 (\emph{character}) the path where are the resources.
}
\item{\bold{replaceSlangs:}}{
 (\emph{logical}) indicates if the slangs are replace or not.
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{bdpar.Options}},
         \code{\link{ContractionPipe}}, \code{\link{File2Pipe}},
         \code{\link{FindEmojiPipe}}, \code{\link{FindEmoticonPipe}},
         \code{\link{FindHashtagPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{GenericPipe}}, \code{\link{ResourceHandler}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
