% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractorEml.R
\name{ExtractorEml}
\alias{ExtractorEml}
\title{Class to handle email files with eml extension}
\description{
This class inherits from the \code{\link{Instance}} class and
implements the functions of extracting the text and the date from an eml type
file.
}
\section{Details}{

The way to indicate which part to choose in the email, when is a multipart email,
is through the \strong{"extractorEML.mpaPartSelected"}
field of \code{\link{bdpar.Options}} variable.
}

\section{Note}{

To be able to use this class it is necessary to have Python installed.
}

\section{Inherit}{

This class inherits from \code{\link{Instance}} and implements the
\code{obtainSource} and \code{obtainDate} abstracts functions.
}

\seealso{
\code{\link{bdpar.Options}}, \code{\link{ExtractorSms}},
\code{\link{ExtractorTwtid}}, \code{\link{ExtractorYtbid}},
\code{\link{Instance}}
}
\section{Super class}{
\code{\link[bdpar:Instance]{bdpar::Instance}} -> \code{ExtractorEml}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ExtractorEml$new()}}
\item \href{#method-obtainDate}{\code{ExtractorEml$obtainDate()}}
\item \href{#method-obtainSource}{\code{ExtractorEml$obtainSource()}}
\item \href{#method-getPartSelectedOnMPAlternative}{\code{ExtractorEml$getPartSelectedOnMPAlternative()}}
\item \href{#method-setPartSelectedOnMPAlternative}{\code{ExtractorEml$setPartSelectedOnMPAlternative()}}
\item \href{#method-toString}{\code{ExtractorEml$toString()}}
\item \href{#method-clone}{\code{ExtractorEml$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addBanPipes">}\href{../../bdpar/html/Instance.html#method-addBanPipes}{\code{bdpar::Instance$addBanPipes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addFlowPipes">}\href{../../bdpar/html/Instance.html#method-addFlowPipes}{\code{bdpar::Instance$addFlowPipes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addProperties">}\href{../../bdpar/html/Instance.html#method-addProperties}{\code{bdpar::Instance$addProperties()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="checkCompatibility">}\href{../../bdpar/html/Instance.html#method-checkCompatibility}{\code{bdpar::Instance$checkCompatibility()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getBanPipes">}\href{../../bdpar/html/Instance.html#method-getBanPipes}{\code{bdpar::Instance$getBanPipes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getData">}\href{../../bdpar/html/Instance.html#method-getData}{\code{bdpar::Instance$getData()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getDate">}\href{../../bdpar/html/Instance.html#method-getDate}{\code{bdpar::Instance$getDate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getFlowPipes">}\href{../../bdpar/html/Instance.html#method-getFlowPipes}{\code{bdpar::Instance$getFlowPipes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getNamesOfProperties">}\href{../../bdpar/html/Instance.html#method-getNamesOfProperties}{\code{bdpar::Instance$getNamesOfProperties()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getPath">}\href{../../bdpar/html/Instance.html#method-getPath}{\code{bdpar::Instance$getPath()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getProperties">}\href{../../bdpar/html/Instance.html#method-getProperties}{\code{bdpar::Instance$getProperties()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getSource">}\href{../../bdpar/html/Instance.html#method-getSource}{\code{bdpar::Instance$getSource()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getSpecificProperty">}\href{../../bdpar/html/Instance.html#method-getSpecificProperty}{\code{bdpar::Instance$getSpecificProperty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="invalidate">}\href{../../bdpar/html/Instance.html#method-invalidate}{\code{bdpar::Instance$invalidate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="isInstanceValid">}\href{../../bdpar/html/Instance.html#method-isInstanceValid}{\code{bdpar::Instance$isInstanceValid()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="isSpecificProperty">}\href{../../bdpar/html/Instance.html#method-isSpecificProperty}{\code{bdpar::Instance$isSpecificProperty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setData">}\href{../../bdpar/html/Instance.html#method-setData}{\code{bdpar::Instance$setData()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setDate">}\href{../../bdpar/html/Instance.html#method-setDate}{\code{bdpar::Instance$setDate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setProperties">}\href{../../bdpar/html/Instance.html#method-setProperties}{\code{bdpar::Instance$setProperties()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setSource">}\href{../../bdpar/html/Instance.html#method-setSource}{\code{bdpar::Instance$setSource()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setSpecificProperty">}\href{../../bdpar/html/Instance.html#method-setSpecificProperty}{\code{bdpar::Instance$setSpecificProperty()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{ExtractorEml}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorEml$new(path, PartSelectedOnMPAlternative = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. Path of the eml file.}

\item{\code{PartSelectedOnMPAlternative}}{A \code{\link{character}} value. Configuration to read
the eml files. If it is NULL, checks if is defined in the
\strong{"extractorEML.mpaPartSelected"} field of \emph{\link{bdpar.Options}}
variable.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-obtainDate"></a>}}
\if{latex}{\out{\hypertarget{method-obtainDate}{}}}
\subsection{Method \code{obtainDate()}}{
Obtains the date of the eml file. Calls the function
\emph{read_emails} and obtains the date of the file indicated in the path
and then transforms it into the generic date format, that is
"\%a \%b \%d \%H:\%M:\%S \%Z \%Y" (Example: "Thu May 02 06:52:36 UTC 2013").
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorEml$obtainDate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-obtainSource"></a>}}
\if{latex}{\out{\hypertarget{method-obtainSource}{}}}
\subsection{Method \code{obtainSource()}}{
Obtains the source of the eml file. Calls the function
\emph{read_emails} and obtains the source of the file indicated in the
path. In addition, it initializes the data with the initial source.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorEml$obtainSource()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getPartSelectedOnMPAlternative"></a>}}
\if{latex}{\out{\hypertarget{method-getPartSelectedOnMPAlternative}{}}}
\subsection{Method \code{getPartSelectedOnMPAlternative()}}{
Gets of \emph{PartSelectedOnMPAlternative} variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorEml$getPartSelectedOnMPAlternative()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of \emph{PartSelectedOnMPAlternative} variable.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setPartSelectedOnMPAlternative"></a>}}
\if{latex}{\out{\hypertarget{method-setPartSelectedOnMPAlternative}{}}}
\subsection{Method \code{setPartSelectedOnMPAlternative()}}{
Gets of \code{PartSelectedOnMPAlternative} variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorEml$setPartSelectedOnMPAlternative(PartSelectedOnMPAlternative)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{PartSelectedOnMPAlternative}}{A \code{\link{character}} value. The
new value of \emph{PartSelectedOnMPAlternative} variable.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-toString"></a>}}
\if{latex}{\out{\hypertarget{method-toString}{}}}
\subsection{Method \code{toString()}}{
Returns a \code{\link{character}} representing the instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorEml$toString()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{\link{Instance}} \code{\link{character}} representation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorEml$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
