% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractorTwtid.R
\name{ExtractorTwtid}
\alias{ExtractorTwtid}
\title{Class to handle tweets files with twtid extension}
\description{
This class inherits from the \code{\link{Instance}} class and
implements the functions of extracting the text and the date of an twtid type
file.
}
\section{Details}{


Twitter connection is handled through the \code{\link{Connections}} class
which loads the Twitter API credentials from the \code{\link{bdpar.Options}} object.
Additionally, to increase the processing speed, each twitter query is stored
in a cache to avoid the execution of duplicated queries. To enable this option,
cache location should be in the \strong{"cache.twitter.path"} field of
\code{\link{bdpar.Options}} variable. This variable has to be the
path to store the tweets and it is necessary that it has two folder named:
"_spam_" and "_ham_"
}

\section{Inherit}{

This class inherits from \code{\link{Instance}} and implements the
\code{obtainSource} and \code{obtainDate} abstracts functions.
}

\seealso{
\code{\link{bdpar.Options}}, \code{\link{Connections}},
         \code{\link{ExtractorEml}}, \code{\link{ExtractorSms}},
         \code{\link{ExtractorYtbid}}, \code{\link{Instance}},
}
\section{Super class}{
\code{\link[bdpar:Instance]{bdpar::Instance}} -> \code{ExtractorTwtid}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExtractorTwtid-new}{\code{ExtractorTwtid$new()}}
\item \href{#method-ExtractorTwtid-obtainId}{\code{ExtractorTwtid$obtainId()}}
\item \href{#method-ExtractorTwtid-getId}{\code{ExtractorTwtid$getId()}}
\item \href{#method-ExtractorTwtid-obtainDate}{\code{ExtractorTwtid$obtainDate()}}
\item \href{#method-ExtractorTwtid-obtainSource}{\code{ExtractorTwtid$obtainSource()}}
\item \href{#method-ExtractorTwtid-toString}{\code{ExtractorTwtid$toString()}}
\item \href{#method-ExtractorTwtid-clone}{\code{ExtractorTwtid$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addBanPipes"><a href='../../bdpar/html/Instance.html#method-Instance-addBanPipes'><code>bdpar::Instance$addBanPipes()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addFlowPipes"><a href='../../bdpar/html/Instance.html#method-Instance-addFlowPipes'><code>bdpar::Instance$addFlowPipes()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addProperties"><a href='../../bdpar/html/Instance.html#method-Instance-addProperties'><code>bdpar::Instance$addProperties()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="checkCompatibility"><a href='../../bdpar/html/Instance.html#method-Instance-checkCompatibility'><code>bdpar::Instance$checkCompatibility()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getBanPipes"><a href='../../bdpar/html/Instance.html#method-Instance-getBanPipes'><code>bdpar::Instance$getBanPipes()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getData"><a href='../../bdpar/html/Instance.html#method-Instance-getData'><code>bdpar::Instance$getData()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getDate"><a href='../../bdpar/html/Instance.html#method-Instance-getDate'><code>bdpar::Instance$getDate()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getFlowPipes"><a href='../../bdpar/html/Instance.html#method-Instance-getFlowPipes'><code>bdpar::Instance$getFlowPipes()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getNamesOfProperties"><a href='../../bdpar/html/Instance.html#method-Instance-getNamesOfProperties'><code>bdpar::Instance$getNamesOfProperties()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getPath"><a href='../../bdpar/html/Instance.html#method-Instance-getPath'><code>bdpar::Instance$getPath()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getProperties"><a href='../../bdpar/html/Instance.html#method-Instance-getProperties'><code>bdpar::Instance$getProperties()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getSource"><a href='../../bdpar/html/Instance.html#method-Instance-getSource'><code>bdpar::Instance$getSource()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getSpecificProperty"><a href='../../bdpar/html/Instance.html#method-Instance-getSpecificProperty'><code>bdpar::Instance$getSpecificProperty()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="invalidate"><a href='../../bdpar/html/Instance.html#method-Instance-invalidate'><code>bdpar::Instance$invalidate()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="isInstanceValid"><a href='../../bdpar/html/Instance.html#method-Instance-isInstanceValid'><code>bdpar::Instance$isInstanceValid()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="isSpecificProperty"><a href='../../bdpar/html/Instance.html#method-Instance-isSpecificProperty'><code>bdpar::Instance$isSpecificProperty()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setData"><a href='../../bdpar/html/Instance.html#method-Instance-setData'><code>bdpar::Instance$setData()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setDate"><a href='../../bdpar/html/Instance.html#method-Instance-setDate'><code>bdpar::Instance$setDate()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setProperties"><a href='../../bdpar/html/Instance.html#method-Instance-setProperties'><code>bdpar::Instance$setProperties()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setSource"><a href='../../bdpar/html/Instance.html#method-Instance-setSource'><code>bdpar::Instance$setSource()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setSpecificProperty"><a href='../../bdpar/html/Instance.html#method-Instance-setSpecificProperty'><code>bdpar::Instance$setSpecificProperty()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorTwtid-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorTwtid-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{ExtractorTwtid}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorTwtid$new(path, cachePath = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. Path of the twtid file.}

\item{\code{cachePath}}{A \code{\link{character}} value. Path of the cache
location. If it is NULL, checks if is defined in the
\strong{"cache.twitter.path"} field of \code{\link{bdpar.Options}}
variable.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorTwtid-obtainId"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorTwtid-obtainId}{}}}
\subsection{Method \code{obtainId()}}{
Obtains the ID of an specific tweet. Reads the ID of the
file indicated in the variable path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorTwtid$obtainId()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorTwtid-getId"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorTwtid-getId}{}}}
\subsection{Method \code{getId()}}{
Gets the ID of an specific tweet.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorTwtid$getId()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of tweet ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorTwtid-obtainDate"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorTwtid-obtainDate}{}}}
\subsection{Method \code{obtainDate()}}{
Obtains the date from a specific tweet ID. If the tweet has
been previously cached the tweet date is loaded from cache path. Otherwise,
the request is performed using Twitter API and the date is automatically
formatted to "%a %b %d %H:%M:%S %Z %Y" (i.e. "Thu May 02 06:52:36 UTC 2013").
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorTwtid$obtainDate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorTwtid-obtainSource"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorTwtid-obtainSource}{}}}
\subsection{Method \code{obtainSource()}}{
Obtains the source from a specific tweet ID. If the tweet
has previously been cached the source is loaded from cache path.
Otherwise, the request is performed using on Twitter API.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorTwtid$obtainSource()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorTwtid-toString"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorTwtid-toString}{}}}
\subsection{Method \code{toString()}}{
Returns a \code{\link{character}} representing the instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorTwtid$toString()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{\link{Instance}} \code{\link{character}} representation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorTwtid-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorTwtid-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorTwtid$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
