% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beanz_stan.R
\name{bzCallStan}
\alias{bzCallStan}
\title{Call STAN models}
\usage{
bzCallStan(mdls = c("nse", "fs", "sr", "bs", "srs", "ds", "eds"), dat.sub,
  var.estvar, var.cov, par.pri = c(B = 1000, C = 1000, D = 1),
  var.nom = NULL, delta = 0, prior.sig = 1, chains = 4, ...)
}
\arguments{
\item{mdls}{name of the Bayesian HTE model. The options are:

\describe{
  \item{nse}{No subgroup effect model}
  \item{fs}{Full stratification model}
  \item{sr}{Simple regression model}
  \item{bs}{Basic shrinkage model}
  \item{srs}{Simple regression with shrinkage model}
  \item{ds}{Dixon-Simon model}
  \item{eds}{Extended Dixon-Simon model}
}}

\item{dat.sub}{dataset with subgroup treatment effect summary data}

\item{var.estvar}{column names in dat.sub that corresponds to treatment effect
estimation and the estimated variance}

\item{var.cov}{array of column names in dat.sub that corresponds to binary or
ordinal baseline covariates}

\item{par.pri}{vector of prior parameters for each model. See
    \code{\link{beanz-package}} for the details of model specification.

\describe{
  \item{nse, fs}{\code{B}}
  \item{sr}{\code{B}, \code{C}}
  \item{bs, ds, eds}{\code{B}, \code{D}}
  \item{srs}{\code{B}, \code{C}, \code{D}}
}}

\item{var.nom}{array of column names in dat.sub that corresponds to nominal
baseline covariates}

\item{delta}{parameter for specifying the informative priors of \eqn{\sigma_g}}

\item{prior.sig}{option for the informative prior on \eqn{\sigma_g}. 0: uniform prior and
1: log-normal prior}

\item{chains}{STAN options. Number of chains.}

\item{...}{options to call STAN sampling. These options include
\code{iter}, \code{warmup}, \code{thin}, \code{algorithm}.
See \code{rstan::sampling} for details.}
}
\value{
A class \code{beanz.stan} list containing
 \describe{
   \item{mdl}{name of the Bayesian HTE model}
   \item{stan.rst}{raw \code{rstan} \code{sampling} results}
   \item{smps}{matrix of the posterior samples}
   \item{get.mus}{method to return the posterior sample of the subgroup treatment effects}
   \item{DIC}{DIC value}
   \item{looic}{leave-one-out cross-validation information criterion}
   \item{rhat}{Gelman and Rubin potential scale reduction statistic}
   \item{prior.sig}{option for the informative prior on \eqn{\sigma_g}}
   \item{delta}{parameter for specifying the informative priors of \eqn{\sigma_g}}
}
}
\description{
Call STAN to draw posterior samples for Bayesian HTE models.
}
\examples{
var.cov    <- c("sodium", "lvef", "any.vasodilator.use");
var.resp   <- "y";
var.trt    <- "trt";
var.censor <- "censor";
resptype   <- "survival";
var.estvar <- c("Estimate", "Variance");

subgrp.effect <- bzGetSubgrpRaw(solvd.sub,
                                  var.resp   = var.resp,
                                  var.trt    = var.trt,
                                  var.cov    = var.cov,
                                  var.censor = var.censor,
                                  resptype   = resptype);

rst.nse    <- bzCallStan("nse", dat.sub=subgrp.effect,
                         var.estvar = var.estvar, var.cov = var.cov,
                         par.pri = c(B=1000),
                         chains=4, iter=600,
                         warmup=200, thin=2, seed=1000);

rst.sr     <- bzCallStan("sr", dat.sub=subgrp.effect,
                        var.estvar=var.estvar, var.cov = var.cov,
                        par.pri=c(B=1000, C=1000),
                        chains=4, iter=600,
                        warmup=200, thin=2, seed=1000);
}
