# Sample size estimation for log transformation data
logdata <-function()
{
cat("\n")
cat("****************************************************************************\n")
cat("*                            Required information                          *\n")
cat("*--------------------------------------------------------------------------*\n")
cat("* CV    stands for the coefficient of variation                            *\n")
cat("* Theta is the difference in average BA between the two formulations       *\n")
cat("*       expressed in percentage of the average reference BA.               *\n")
cat("*       Theta=Ut/Ur, where Ut and Ur denote the median BA for test and     *\n")
cat("*       reference.                                                         *\n")
cat("* Be careful!! Theta range should between 0.8 and 1.25                     *\n")
cat("* n     is the initial guess of sample size number for per sequence        *\n")
cat("****************************************************************************\n")
cat("\n")
cat("\n")
cat(" Enter CV (%)(e.g. 0.05)\n")
CV <- scan(nlines=1,quiet=TRUE)
cat("\n")
cat("Enter Theta (%)(e.g. 0.85)\n")
Theta <- scan(nlines=1,quiet=TRUE)
cat("\n")
cat("Enter power (%)(e.g. 80 or 90)\n")
epower <- scan(nlines=1,quiet=TRUE)
cat("\n")
cat("Enter n (e.g. 10)\n")
n <- scan(nlines=1,quiet=TRUE)
cat("\n")

T_alpha<-qt(0.95,((2*n)-2))

  if (Theta == 1){
  T_beta<-qt(1-((1-(epower*0.01))/2),((2*n)-2))
  n<-((T_alpha+ T_beta)^2)*((CV/log(1.25))^2)
  i<-round(n,2)
  xi<-round(n,0)
  cat("\n")
  cat("--------------------------------------------------------------------------\n")
  cat("                               <<Suggestion>>                             \n")
  cat("--------------------------------------------------------------------------\n")
  cat("             n>=",i," (sample size number for per sequence)               \n")
  cat("            Total sample size",2*xi,"                                     \n")
  cat("--------------------------------------------------------------------------\n")
  cat("\n")
    go() 
  }
   else{
    if (1 < Theta && Theta <1.25) {
    T_beta<-qt((epower*0.01),((2*n)-2))
     n<-((T_alpha+ T_beta)^2)*((CV/(log(1.25)-log(Theta)))^2)
    i<-round(n,2)
    xi<-round(n,0)
    cat("\n")
    cat("--------------------------------------------------------------------------\n")
    cat("                               <<Suggestion>>                             \n")
    cat("--------------------------------------------------------------------------\n")
    cat("             n>=",i," (sample size number for per sequence)               \n")
    cat("            Total sample size",2*xi,"                                     \n")
    cat("--------------------------------------------------------------------------\n")
    cat("\n")
     go() 
    }
   else{
    if (0.8 < Theta && Theta <1) {
     T_beta<-qt((epower*0.01),((2*n)-2))
     n<-((T_alpha+ T_beta)^2)*((CV/(log(0.8)-log(Theta)))^2)
     i<-round(n,2)
     xi<-round(n,0)
     cat("\n")
     cat("--------------------------------------------------------------------------\n")
     cat("                               <<Suggestion>>                             \n")
     cat("--------------------------------------------------------------------------\n")
     cat("             n>=",i," (sample size number for per sequence)               \n")
     cat("            Total sample size",2*xi,"                                     \n")
     cat("--------------------------------------------------------------------------\n")
     cat("\n")
       go()
    }
  }
 }
}
