% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/extract_treelog_filename_from_beast2_input_file.R
\name{extract_treelog_filename_from_beast2_input_file}
\alias{extract_treelog_filename_from_beast2_input_file}
\title{Internal function to extract the treelog filename for a BEAST2 input file}
\usage{
extract_treelog_filename_from_beast2_input_file(input_filename)
}
\arguments{
\item{input_filename}{the name of a BEAST2 input XML file.
This file usually has an \code{.xml} extension.
Use \link{create_temp_input_filename} to create a temporary
filename with that extension.}
}
\value{
the treelog filename for a BEAST2 input file
}
\description{
Extract the treelog filename from a BEAST2 input file
}
\examples{
beast2_input_filename <- get_beastier_tempfilename()
beautier::create_beast2_input_file_from_model(
  input_filename = beautier::get_beautier_path("test_output_0.fas"),
  output_filename = beast2_input_filename
)
extract_treelog_filename_from_beast2_input_file(
  input_filename = beast2_input_filename
)
file.remove(beast2_input_filename)
}
\author{
Richèl J.C. Bilderbeek
}
