% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{int_tte_df}
\alias{int_tte_df}
\title{Internal Time-to-Event Control Data for Propensity Score Balancing}
\format{
\subsection{\code{int_tte_df}}{

A data frame with 160 rows and 10 columns:
\describe{
\item{subjid}{Unique subject ID}
\item{y}{Response (observed time at which the participant either had an event or was censored)}
\item{enr_time}{Enrollment time}
\item{total_time}{Time from study start}
\item{event}{Event indicator (1: event; 0: censored)}
\item{trt}{Treatment indicator, where 0 = control and 1 = active treatment}
\item{cov1}{Covariate 1, which is normally distributed around 62 with a SD of 8}
\item{cov2}{Covariate 2, which is binary (0 vs. 1) with about 40\% of participants having level 1}
\item{cov3}{Covariate 3, which is binary (0 vs. 1) with about 40\% of participants having level 1}
\item{cov4}{Covariate 4, which is binary (0 vs. 1) with about 60\% of participants having level 1}
}
}
}
\usage{
int_tte_df
}
\description{
This is a simulated dataset used to illustrate Bayesian dynamic borrowing in
the case when borrowing from an external control arm with a time-to-event endpoint,
where the baseline covariate distributions of the internal and external data
are balanced via inverse probability weighting.
}
\keyword{datasets}
