% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{robustify_norm}
\alias{robustify_norm}
\title{Robustify Normal Distributions}
\usage{
robustify_norm(prior, n, weights = c(0.5, 0.5))
}
\arguments{
\item{prior}{Normal or Multivariate Normal distributional object}

\item{n}{Number of theoretical participants (or events, for time-to-event data)}

\item{weights}{Vector of weights, where the first number corresponds to the
informative component and the second is the vague}
}
\value{
mixture distribution
}
\description{
Adds vague normal component, where the level of vagueness is controlled by
the \code{n} parameter
}
\details{
In cases with a normal endpoint, a robust mixture prior can be created by
adding a vague normal component to any normal prior with mean \eqn{\theta}
and variance \eqn{\sigma^2}.The vague component is calculated to have the
same mean \eqn{\theta} and variance equal to \eqn{\sigma^2 \times n}, where
\code{n} is the specified number of theoretical participants. If robustifying a normal
power prior that was calculated from external control data and \code{n} is defined as
the number of external control participants, and the vague component would
then correspond to one external control participant's worth of data.
}
\examples{
library(distributional)
robustify_norm(dist_normal(0,1), n = 15)
}
