% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input_distr.R
\name{create_beast2_input_distr_prior}
\alias{create_beast2_input_distr_prior}
\title{Creates the prior section in the distribution section
of a BEAST2 XML parameter file}
\usage{
create_beast2_input_distr_prior(site_models, clock_models, tree_priors,
  mrca_priors = NA)
}
\arguments{
\item{site_models}{one or more site models,
as returned by \code{\link{create_site_model}}}

\item{clock_models}{a list of one or more clock models,
as returned by \code{\link{create_clock_model}}}

\item{tree_priors}{one or more tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{mrca_priors}{a list of one or more Most Recent Common Ancestor priors,
as returned by \code{\link{create_mrca_prior}}}
}
\description{
Creates the prior section in the distribution section
of a BEAST2 XML parameter file
}
\note{
this function is not intended for regular use, thus its
  long name length is accepted
}
\examples{
 # <distribution id="posterior" spec="util.CompoundDistribution">
 #     <distribution id="prior" spec="util.CompoundDistribution">
 #       HERE, where the ID of the distribution is 'prior'
 #     </distribution>
 #     <distribution id="likelihood" ...>
 #     </distribution>
 # </distribution>
}
\seealso{
this function is called by \code{\link{create_beast2_input_distr}},
  together with \code{\link{create_beast2_input_distr_lh}}
}
\author{
Richel J.C. Bilderbeek
}
