% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_beta_distr}
\alias{create_beta_distr}
\alias{create_distr_beta}
\title{Create a beta distribution}
\usage{
create_beta_distr(id = NA, alpha = create_alpha_param(),
  beta = create_beta_param())
}
\arguments{
\item{id}{the distribution's ID}

\item{alpha}{the alpha shape parameter,
as returned by \code{\link{create_alpha_param}}. The value
of alpha must be at least 0.0.}

\item{beta}{the beta shape parameter,
as returned by \code{\link{create_beta_param}}. The value
of beta must be at least 1.0.}
}
\value{
a beta distribution
}
\description{
Create a beta distribution
}
\examples{
  beta_distr <- create_beta_distr()

  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_beta_distr.xml",
    tree_priors = create_yule_tree_prior(
      birth_rate_distr = beta_distr
    )
  )
  testit::assert(file.exists("create_beta_distr.xml"))
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richel J.C. Bilderbeek
}
