% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_site_models.R
\name{create_jc69_site_models}
\alias{create_jc69_site_models}
\title{Creates a JC69_site_model for each ID}
\usage{
create_jc69_site_models(ids)
}
\arguments{
\item{ids}{one or more alignments' IDs.
IDs can be extracted from their FASTA filesnames
with \code{\link{get_ids}})}
}
\value{
a list of site_models
}
\description{
Creates a JC69_site_model for each ID
}
\examples{
  fasta_filenames <- get_beautier_paths(
    c("anthus_aco.fas", "anthus_nd2.fas")
  )
  site_models <- create_jc69_site_models(c("anthus_aco", "anthus_nd2"))
  create_beast2_input_file(
    fasta_filenames,
    "create_jc69_site_models.xml",
    site_models = site_models
  )
  testit::assert(file.exists("create_jc69_site_models.xml"))
}
\seealso{
The alignment IDs can be deduced from the FASTA filenames,
  using \code{\link{get_ids}}
}
\author{
Richel J.C. Bilderbeek
}
