% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_clock_model.R
\name{create_strict_clock_model}
\alias{create_strict_clock_model}
\alias{create_clock_model_strict}
\title{Create a strict clock model}
\usage{
create_strict_clock_model(id = NA,
  clock_rate_param = create_clock_rate_param(),
  clock_rate_distr = create_uniform_distr())
}
\arguments{
\item{id}{an alignment's IDs.
An ID can be extracted from its FASTA filesname
with \code{\link{get_ids}})}

\item{clock_rate_param}{the clock rate's parameter,
as created by the \code{\link{create_clock_rate_param}} function}

\item{clock_rate_distr}{the clock rate's distribution,
as created by a \code{\link{create_distr}} function}
}
\value{
a strict clock_model
}
\description{
Create a strict clock model
}
\examples{
  strict_clock_model <- create_strict_clock_model()

  create_beast2_input_file(
    get_fasta_filename(),
    "create_strict_clock_model.xml",
    clock_models = strict_clock_model
  )
  testit::assert(file.exists("create_strict_clock_model.xml"))

  strict_clock_model_gamma <- create_strict_clock_model(
    clock_rate_distr = create_gamma_distr()
  )

  create_beast2_input_file(
    get_fasta_filename(),
    "create_strict_clock_model_gamma.xml",
    clock_models = strict_clock_model_gamma
  )
  testit::assert(file.exists("create_strict_clock_model_gamma.xml"))
}
\author{
Richel J.C. Bilderbeek
}
