% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_clock_models.R
\name{create_strict_clock_models}
\alias{create_strict_clock_models}
\title{Creates n strict clock_models}
\usage{
create_strict_clock_models(ids)
}
\arguments{
\item{ids}{the alignment IDs}
}
\value{
a list of strict_clock objects
}
\description{
Creates n strict clock_models
}
\examples{
  fasta_filenames <- get_beautier_paths(
    c("anthus_aco.fas", "anthus_nd2.fas")
  )
  clock_models <- create_strict_clock_models(
    ids = get_ids(fasta_filenames)
  )

  create_beast2_input_file(
    fasta_filenames,
    "create_strict_clock_models.xml",
    clock_models = clock_models
  )
  testit::assert(file.exists("create_strict_clock_models.xml"))
}
\seealso{
The alignment IDs can be deduced from the FASTA filenames,
  using \code{\link{get_ids}}
}
