% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasta_to_phylo.R
\name{fasta_to_phylo}
\alias{fasta_to_phylo}
\title{Create a random phylogeny, with the same taxa names as the FASTA file
  and the desired crown age}
\usage{
fasta_to_phylo(fasta_filename, crown_age)
}
\arguments{
\item{fasta_filename}{a FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{crown_age}{the crown age of the phylogeny}
}
\value{
a a random phylogy, with the same taxa names as the FASTA file
  and the desired crown age
}
\description{
Create a random phylogeny, with the same taxa names as the FASTA file
  and the desired crown age
}
\examples{
  # Create a random phylogy, with
  # - the same taxa names as the FASTA file
  # - the desired crown age
  fasta_filename <- get_fasta_filename()
  initial_phylogeny <- fasta_to_phylo(
    fasta_filename,
    crown_age = 15
   )

  # Crown age fixed to the crown age of the phylogeny
  # Note: prefer create_beast2_input_file
  create_beast2_input_file_1_12(
    input_filenames = fasta_filename,
    "fasta_to_phylo.xml",
    fixed_crown_age = TRUE,
    initial_phylogenies = initial_phylogeny
  )
  testthat::expect_true(file.exists("fasta_to_phylo.xml"))
}
