% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrca_prior_to_xml_prior_distr.R
\name{mrca_prior_to_xml_prior_distr}
\alias{mrca_prior_to_xml_prior_distr}
\title{Creates the distribution section in the prior section of the
distribution section of a BEAST2 XML parameter file.
These lines start with '<distribution id='}
\usage{
mrca_prior_to_xml_prior_distr(mrca_prior, has_non_strict_clock_model = FALSE,
  taxa_names_with_ids = NULL, is_first = TRUE)
}
\arguments{
\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{has_non_strict_clock_model}{boolean to indicate that the is
already at least one non-strict (i.e. relaxed log-normal) clock model}

\item{taxa_names_with_ids}{taxa names that already have received
an ID. Causes the XML to \code{idref} these}

\item{is_first}{is this the first MRCA prior?}
}
\description{
Creates the distribution section in the prior section of the
distribution section of a BEAST2 XML parameter file.
These lines start with '<distribution id='
}
\examples{
 # <distribution id="posterior" spec="util.CompoundDistribution">
 #     <distribution id="prior" spec="util.CompoundDistribution">
 #       HERE, where the ID of the distribution is 'prior'
 #     </distribution>
 #     <distribution id="likelihood" ...>
 #     </distribution>
 # </distribution>
}
\author{
Richel J.C. Bilderbeek
}
