% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastas_to_phylos.R
\name{fastas_to_phylos}
\alias{fastas_to_phylos}
\title{Create one or more random phylogenies.}
\usage{
fastas_to_phylos(fasta_filenames, crown_age)
}
\arguments{
\item{fasta_filenames}{One or more FASTA filenames.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{crown_age}{the crown age of the phylogeny}
}
\value{
a \code{multiPhylo} with as much phylogenies
  as there were FASTA filenames. Each phylogeny has
  the same taxa names as its corresponding FASTA file.
  All phylogenies have the same crown age.
}
\description{
Per FASTA file, one random phylogeny is created,
with the same taxa names as that FASTA file.
All phylogenies have the same crown age.
}
\examples{
  # Create two random phylogies, with
  # - the same taxa names as the FASTA files
  # - the desired crown age
  fasta_filenames <- get_beautier_paths(
    c("anthus_aco.fas")
  )
  initial_phylogenies <- fastas_to_phylos(
    fasta_filenames,
    crown_age = 15
  )
}
\author{
Richèl J.C. Bilderbeek
}
