% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_clock_model.R
\name{create_rln_clock_model}
\alias{create_rln_clock_model}
\alias{create_clock_model_rln}
\title{Create a relaxed log-normal clock model}
\usage{
create_rln_clock_model(
  id = NA,
  mean_rate_prior_distr = create_uniform_distr(),
  ucldstdev_distr = create_gamma_distr(),
  mparam_id = NA,
  mean_clock_rate = "1.0",
  n_rate_categories = -1,
  normalize_mean_clock_rate = FALSE,
  dimension = NA
)
}
\arguments{
\item{id}{an alignment's IDs.
An ID can be extracted from its FASTA filename
with \code{\link{get_alignment_ids_from_fasta_filenames}})}

\item{mean_rate_prior_distr}{the mean clock rate prior distribution,
as created by a \code{\link{create_distr}} function}

\item{ucldstdev_distr}{the standard deviation of the uncorrelated
log-normal distribution,
as created by a \code{\link{create_distr}} function}

\item{mparam_id}{the ID of the M parameter in the \code{branchRateModel},
set to NA to have it initialized}

\item{mean_clock_rate}{the mean clock rate, 1.0 by default
(is called \code{ucld_stdev} in XML, where \code{ucld_stdev} is always 0.1)}

\item{n_rate_categories}{the number of rate categories.
-1 is default,
0 denotes as much rates as branches}

\item{normalize_mean_clock_rate}{normalize the mean clock rate}

\item{dimension}{the dimensionality of the relaxed clock model.
Leave NA to let beautier calculate it.
Else, the dimensionality of the clock
equals twice the number of taxa minus two.}
}
\value{
a relaxed log-normal clock_model
}
\description{
Create a relaxed log-normal clock model
}
\examples{
  rln_clock_model <- create_rln_clock_model()

  beast2_input_file <- tempfile(fileext = ".xml")
  create_beast2_input_file(
    get_fasta_filename(),
    beast2_input_file,
    clock_model = rln_clock_model
  )
  testit::assert(file.exists(beast2_input_file))

  rln_clock_model_exp <- create_rln_clock_model(
    mean_rate_prior_distr = create_exp_distr()
  )

  beast2_input_file <- tempfile(fileext = ".xml")
  create_beast2_input_file(
    get_fasta_filename(),
    beast2_input_file,
    clock_model = rln_clock_model_exp
  )
  testit::assert(file.exists(beast2_input_file))
}
\author{
Richèl J.C. Bilderbeek
}
