% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_distr.R
\name{is_beta_distr}
\alias{is_beta_distr}
\title{Determine if the object is a valid
beta distribution,
as created by \code{\link{create_beta_distr}}}
\usage{
is_beta_distr(x)
}
\arguments{
\item{x}{an object, to be determined if it is a valid
beta distribution,}
}
\value{
TRUE if x is a valid beta distribution,
  FALSE otherwise
}
\description{
Determine if the object is a valid
beta distribution,
as created by \code{\link{create_beta_distr}}
}
\examples{
library(testthat)

expect_true(is_beta_distr(create_beta_distr()))
expect_false(is_beta_distr(create_exp_distr()))

expect_false(is_beta_distr(NA))
expect_false(is_beta_distr(NULL))
expect_false(is_beta_distr("nonsense"))
}
\seealso{
use \code{\link{is_distr}} to see if x is any
  distribution
}
\author{
Richèl J.C. Bilderbeek
}
