% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gamma_site_model_n_params.R
\name{get_gamma_site_model_n_params}
\alias{get_gamma_site_model_n_params}
\title{Get the number of distributions a site model has}
\usage{
get_gamma_site_model_n_params(gamma_site_model)
}
\arguments{
\item{gamma_site_model}{a site model's gamma site model,
as returned by \code{\link{create_gamma_site_model}}}
}
\value{
the number of parameters a site model has
}
\description{
Get the number of distributions a site model has
}
\examples{
  testit::assert(
    get_gamma_site_model_n_params(
      create_gamma_site_model(gamma_cat_count = 0)
    ) == 0
  )
  testit::assert(
    get_gamma_site_model_n_params(
      create_gamma_site_model(gamma_cat_count = 1)
    ) == 0
  )
  testit::assert(
    get_gamma_site_model_n_params(
      create_gamma_site_model(
        gamma_cat_count = 2,
        gamma_shape_prior_distr = create_exp_distr()
      )
    ) == 1
  )
}
\author{
Richèl J.C. Bilderbeek
}
