% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determinantStructure.R
\name{determinantStructure}
\alias{determinantStructure}
\alias{determinantVar}
\alias{subdeterminants}
\alias{subdeterminantProducts}
\alias{plot.determinantStructure}
\alias{print.determinantStructure}
\title{Determinant Structure specification}
\usage{
determinantStructure(name, selection = NULL, ...)

determinantVar(name, selection = NULL, ...)

subdeterminants(name, selection = NULL, ...)

subdeterminantProducts(name, selection = NULL, ...)

\method{plot}{determinantStructure}(x, useDiagrammeR = FALSE, ...)

\method{print}{determinantStructure}(x, ...)
}
\arguments{
\item{name}{The name of the variable that is specified.}

\item{selection}{A regular expression to use to select the
variables in a dataframe that are considered items that
together form this variable. For \code{determinantStructure}, a
list can be provided that also contains a named regular
expression with the name 'behaviorRegEx', which specifies
the name of the behavior to which this determinant structure
pertains.}

\item{...}{Any additional arguments are other determinant structure
building functions. These are used to construct the determinant
structure 'tree'.}

\item{x}{The \code{determinantStructure} object to print or plot.}

\item{useDiagrammeR}{Whether to simply use \code{print(plot(x))}
(if \code{FALSE}) or whether to use \link[data.tree:ToDiagrammeRGraph]{data.tree::ToDiagrammeRGraph},
tweak it a bit, by setting global graph attributes, and then
using \link[DiagrammeR:render_graph]{DiagrammeR::render_graph} (if \code{TRUE}).}
}
\value{
A \code{determinantStructure} object, which is a
\link{data.tree} object.
}
\description{
These functions can be used to specify a determinant structure: a
hierarchical structure of determinants that can then be
conveniently plotted and analysed, for example using
\link{detStructCIBER}. These functions are made to be used together;
see the example and the forthcoming article for more information.
}
\details{
This family of functions will be explained more in detail in a
forthcoming paper.

\code{plot} and \code{print} methods plot and print a
\code{determinantStructure} object.
}
\examples{
determinantStructure('using R',
                     list('using R',
                          behaviorRegEx = 'some RegEx'),
                     determinantVar("Intention",
                                    "another RegEx",
                                    determinantVar("Attitude",
                                                   "third RegEX",
                                                   subdeterminants("Likelihood",
                                                                   "4th RegEx"),
                                                  subdeterminants("Evaluation",
                                                                  "5th RegEx"),
                                                  subdeterminantProducts("attProduct",
                                                                         c("4th RegEx",
                                                                           "5th RegEx"))),
                                    determinantVar("perceivedNorm",
                                                   "6th RegEx",
                                                   subdeterminants("Approval",
                                                                   "7th RegEx"),
                                                   subdeterminants("Motivation to comply",
                                                                   "8th RegEx"),
                                                   subdeterminantProducts("normProduct",
                                                                          c("7th RegEx",
                                                                            "8th RegEx"))),
                                              determinantVar("pbc",
                                                             "9th RegEx",
                                                             subdeterminants("Control beliefs",
                                                                             "10th RegEx"))));

}
\seealso{
\code{\link{detStructAddVarLabels}},
\code{\link{detStructAddVarNames}},
\code{\link{detStructComputeProducts}},
\code{\link{detStructComputeScales}},
\code{\link{detStructCIBER}}
}
\author{
Gjalt-Jorn Peters, \email{gjalt-jorn@a-bc.eu}
}
