% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{to_worms}
\alias{to_worms}
\alias{is_worms}
\alias{is_worms_}
\alias{is_accepted}
\alias{is_accepted_}
\title{Convert Taxon Names to Comply with WoRMS}
\usage{
to_worms(taxon, worms = NULL)

is_worms(.data = NULL, taxon)

is_worms_(.data, taxon)

is_accepted(.data = NULL, taxon)

is_accepted_(.data, taxon)
}
\arguments{
\item{taxon}{\code{\link{character}} vector, containing taxon names}

\item{worms}{an optional table usually created with \code{\link{read_twn}}.}

\item{.data}{data in a \code{data.frame}, \code{data_frame}, 
\code{data.table}, database etc.}
}
\value{
character vector with WoRMS compliant species names

\code{TRUE} for WoRMS compliant species names, 
     \code{FALSE} otherwise.

\code{TRUE} for WoRMS/TWN compliant species names, 
     \code{FALSE} otherwise.
}
\description{
Taxon names are standardized according to the World Register of 
Marine Species (WoRMS) database. The conversion is case-insensitive.
For this conversion, the TWN-list (Taxa Water management the Netherlands) 
is used, extended with species of the Southern North Sea. 
See references below for download locations.
}
\section{Functions}{
\itemize{
\item \code{is_worms}: check if a taxon complies with WoRMS

\item \code{is_worms_}: as \code{is_worms} but suitable for calling from a 
function (see package \pkg{lazyeval}).

\item \code{is_accepted}: check if a taxon complies with WoRMS/TWN

\item \code{is_accepted_}: as \code{is_accepted} but suitable for calling from a 
function (see package \pkg{lazyeval}).
}}

\references{
\url{http://www.marinespecies.org/}

\url{http://sofus.ecosys.nl/taxabase.htm}

\url{http://www.aquo.nl/faq/faq-twn/}
}
